@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin

import com.pulumi.aws.memorydb.MemorydbFunctions.getAclPlain
import com.pulumi.aws.memorydb.MemorydbFunctions.getClusterPlain
import com.pulumi.aws.memorydb.MemorydbFunctions.getParameterGroupPlain
import com.pulumi.aws.memorydb.MemorydbFunctions.getSnapshotPlain
import com.pulumi.aws.memorydb.MemorydbFunctions.getSubnetGroupPlain
import com.pulumi.aws.memorydb.MemorydbFunctions.getUserPlain
import com.pulumi.aws.memorydb.kotlin.inputs.GetAclPlainArgs
import com.pulumi.aws.memorydb.kotlin.inputs.GetAclPlainArgsBuilder
import com.pulumi.aws.memorydb.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.aws.memorydb.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.aws.memorydb.kotlin.inputs.GetParameterGroupPlainArgs
import com.pulumi.aws.memorydb.kotlin.inputs.GetParameterGroupPlainArgsBuilder
import com.pulumi.aws.memorydb.kotlin.inputs.GetSnapshotPlainArgs
import com.pulumi.aws.memorydb.kotlin.inputs.GetSnapshotPlainArgsBuilder
import com.pulumi.aws.memorydb.kotlin.inputs.GetSubnetGroupPlainArgs
import com.pulumi.aws.memorydb.kotlin.inputs.GetSubnetGroupPlainArgsBuilder
import com.pulumi.aws.memorydb.kotlin.inputs.GetUserPlainArgs
import com.pulumi.aws.memorydb.kotlin.inputs.GetUserPlainArgsBuilder
import com.pulumi.aws.memorydb.kotlin.outputs.GetAclResult
import com.pulumi.aws.memorydb.kotlin.outputs.GetClusterResult
import com.pulumi.aws.memorydb.kotlin.outputs.GetParameterGroupResult
import com.pulumi.aws.memorydb.kotlin.outputs.GetSnapshotResult
import com.pulumi.aws.memorydb.kotlin.outputs.GetSubnetGroupResult
import com.pulumi.aws.memorydb.kotlin.outputs.GetUserResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.memorydb.kotlin.outputs.GetAclResult.Companion.toKotlin as getAclResultToKotlin
import com.pulumi.aws.memorydb.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.aws.memorydb.kotlin.outputs.GetParameterGroupResult.Companion.toKotlin as getParameterGroupResultToKotlin
import com.pulumi.aws.memorydb.kotlin.outputs.GetSnapshotResult.Companion.toKotlin as getSnapshotResultToKotlin
import com.pulumi.aws.memorydb.kotlin.outputs.GetSubnetGroupResult.Companion.toKotlin as getSubnetGroupResultToKotlin
import com.pulumi.aws.memorydb.kotlin.outputs.GetUserResult.Companion.toKotlin as getUserResultToKotlin

public object MemorydbFunctions {
    /**
     * Provides information about a MemoryDB ACL.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.memorydb.getAcl({
     *     name: "my-acl",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.memorydb.get_acl(name="my-acl")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.MemoryDb.GetAcl.Invoke(new()
     *     {
     *         Name = "my-acl",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/memorydb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := memorydb.LookupAcl(ctx, &memorydb.LookupAclArgs{
     * 			Name: "my-acl",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.memorydb.MemorydbFunctions;
     * import com.pulumi.aws.memorydb.inputs.GetAclArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MemorydbFunctions.getAcl(GetAclArgs.builder()
     *             .name("my-acl")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:memorydb:getAcl
     *       Arguments:
     *         name: my-acl
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAcl.
     * @return A collection of values returned by getAcl.
     */
    public suspend fun getAcl(argument: GetAclPlainArgs): GetAclResult =
        getAclResultToKotlin(getAclPlain(argument.toJava()).await())

    /**
     * @see [getAcl].
     * @param name Name of the ACL.
     * @param tags Map of tags assigned to the ACL.
     * @return A collection of values returned by getAcl.
     */
    public suspend fun getAcl(name: String, tags: Map<String, String>? = null): GetAclResult {
        val argument = GetAclPlainArgs(
            name = name,
            tags = tags,
        )
        return getAclResultToKotlin(getAclPlain(argument.toJava()).await())
    }

    /**
     * @see [getAcl].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;memorydb&#46;kotlin&#46;inputs&#46;GetAclPlainArgs].
     * @return A collection of values returned by getAcl.
     */
    public suspend fun getAcl(argument: suspend GetAclPlainArgsBuilder.() -> Unit): GetAclResult {
        val builder = GetAclPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAclResultToKotlin(getAclPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a MemoryDB Cluster.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.memorydb.getCluster({
     *     name: "my-cluster",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.memorydb.get_cluster(name="my-cluster")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.MemoryDb.GetCluster.Invoke(new()
     *     {
     *         Name = "my-cluster",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/memorydb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := memorydb.LookupCluster(ctx, &memorydb.LookupClusterArgs{
     * 			Name: "my-cluster",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.memorydb.MemorydbFunctions;
     * import com.pulumi.aws.memorydb.inputs.GetClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MemorydbFunctions.getCluster(GetClusterArgs.builder()
     *             .name("my-cluster")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:memorydb:getCluster
     *       Arguments:
     *         name: my-cluster
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCluster.
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param name Name of the cluster.
     * @param tags Map of tags assigned to the cluster.
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(name: String, tags: Map<String, String>? = null): GetClusterResult {
        val argument = GetClusterPlainArgs(
            name = name,
            tags = tags,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;memorydb&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit): GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a MemoryDB Parameter Group.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.memorydb.getParameterGroup({
     *     name: "my-parameter-group",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.memorydb.get_parameter_group(name="my-parameter-group")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.MemoryDb.GetParameterGroup.Invoke(new()
     *     {
     *         Name = "my-parameter-group",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/memorydb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := memorydb.LookupParameterGroup(ctx, &memorydb.LookupParameterGroupArgs{
     * 			Name: "my-parameter-group",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.memorydb.MemorydbFunctions;
     * import com.pulumi.aws.memorydb.inputs.GetParameterGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MemorydbFunctions.getParameterGroup(GetParameterGroupArgs.builder()
     *             .name("my-parameter-group")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:memorydb:getParameterGroup
     *       Arguments:
     *         name: my-parameter-group
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getParameterGroup.
     * @return A collection of values returned by getParameterGroup.
     */
    public suspend fun getParameterGroup(argument: GetParameterGroupPlainArgs): GetParameterGroupResult =
        getParameterGroupResultToKotlin(getParameterGroupPlain(argument.toJava()).await())

    /**
     * @see [getParameterGroup].
     * @param name Name of the parameter group.
     * @param tags Map of tags assigned to the parameter group.
     * @return A collection of values returned by getParameterGroup.
     */
    public suspend fun getParameterGroup(name: String, tags: Map<String, String>? = null): GetParameterGroupResult {
        val argument = GetParameterGroupPlainArgs(
            name = name,
            tags = tags,
        )
        return getParameterGroupResultToKotlin(getParameterGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getParameterGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;memorydb&#46;kotlin&#46;inputs&#46;GetParameterGroupPlainArgs].
     * @return A collection of values returned by getParameterGroup.
     */
    public suspend fun getParameterGroup(argument: suspend GetParameterGroupPlainArgsBuilder.() -> Unit): GetParameterGroupResult {
        val builder = GetParameterGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getParameterGroupResultToKotlin(getParameterGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a MemoryDB Snapshot.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.memorydb.getSnapshot({
     *     name: "my-snapshot",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.memorydb.get_snapshot(name="my-snapshot")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.MemoryDb.GetSnapshot.Invoke(new()
     *     {
     *         Name = "my-snapshot",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/memorydb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := memorydb.LookupSnapshot(ctx, &memorydb.LookupSnapshotArgs{
     * 			Name: "my-snapshot",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.memorydb.MemorydbFunctions;
     * import com.pulumi.aws.memorydb.inputs.GetSnapshotArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MemorydbFunctions.getSnapshot(GetSnapshotArgs.builder()
     *             .name("my-snapshot")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:memorydb:getSnapshot
     *       Arguments:
     *         name: my-snapshot
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSnapshot.
     * @return A collection of values returned by getSnapshot.
     */
    public suspend fun getSnapshot(argument: GetSnapshotPlainArgs): GetSnapshotResult =
        getSnapshotResultToKotlin(getSnapshotPlain(argument.toJava()).await())

    /**
     * @see [getSnapshot].
     * @param name Name of the snapshot.
     * @param tags Map of tags assigned to the snapshot.
     * @return A collection of values returned by getSnapshot.
     */
    public suspend fun getSnapshot(name: String, tags: Map<String, String>? = null): GetSnapshotResult {
        val argument = GetSnapshotPlainArgs(
            name = name,
            tags = tags,
        )
        return getSnapshotResultToKotlin(getSnapshotPlain(argument.toJava()).await())
    }

    /**
     * @see [getSnapshot].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;memorydb&#46;kotlin&#46;inputs&#46;GetSnapshotPlainArgs].
     * @return A collection of values returned by getSnapshot.
     */
    public suspend fun getSnapshot(argument: suspend GetSnapshotPlainArgsBuilder.() -> Unit): GetSnapshotResult {
        val builder = GetSnapshotPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSnapshotResultToKotlin(getSnapshotPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a MemoryDB Subnet Group.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.memorydb.getSubnetGroup({
     *     name: "my-subnet-group",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.memorydb.get_subnet_group(name="my-subnet-group")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.MemoryDb.GetSubnetGroup.Invoke(new()
     *     {
     *         Name = "my-subnet-group",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/memorydb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := memorydb.LookupSubnetGroup(ctx, &memorydb.LookupSubnetGroupArgs{
     * 			Name: "my-subnet-group",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.memorydb.MemorydbFunctions;
     * import com.pulumi.aws.memorydb.inputs.GetSubnetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MemorydbFunctions.getSubnetGroup(GetSubnetGroupArgs.builder()
     *             .name("my-subnet-group")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:memorydb:getSubnetGroup
     *       Arguments:
     *         name: my-subnet-group
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSubnetGroup.
     * @return A collection of values returned by getSubnetGroup.
     */
    public suspend fun getSubnetGroup(argument: GetSubnetGroupPlainArgs): GetSubnetGroupResult =
        getSubnetGroupResultToKotlin(getSubnetGroupPlain(argument.toJava()).await())

    /**
     * @see [getSubnetGroup].
     * @param name Name of the subnet group.
     * @param tags Map of tags assigned to the subnet group.
     * @return A collection of values returned by getSubnetGroup.
     */
    public suspend fun getSubnetGroup(name: String, tags: Map<String, String>? = null): GetSubnetGroupResult {
        val argument = GetSubnetGroupPlainArgs(
            name = name,
            tags = tags,
        )
        return getSubnetGroupResultToKotlin(getSubnetGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubnetGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;memorydb&#46;kotlin&#46;inputs&#46;GetSubnetGroupPlainArgs].
     * @return A collection of values returned by getSubnetGroup.
     */
    public suspend fun getSubnetGroup(argument: suspend GetSubnetGroupPlainArgsBuilder.() -> Unit): GetSubnetGroupResult {
        val builder = GetSubnetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubnetGroupResultToKotlin(getSubnetGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a MemoryDB User.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.memorydb.getUser({
     *     userName: "my-user",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.memorydb.get_user(user_name="my-user")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.MemoryDb.GetUser.Invoke(new()
     *     {
     *         UserName = "my-user",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/memorydb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := memorydb.LookupUser(ctx, &memorydb.LookupUserArgs{
     * 			UserName: "my-user",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.memorydb.MemorydbFunctions;
     * import com.pulumi.aws.memorydb.inputs.GetUserArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MemorydbFunctions.getUser(GetUserArgs.builder()
     *             .userName("my-user")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:memorydb:getUser
     *       Arguments:
     *         userName: my-user
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUser.
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(argument: GetUserPlainArgs): GetUserResult =
        getUserResultToKotlin(getUserPlain(argument.toJava()).await())

    /**
     * @see [getUser].
     * @param tags Map of tags assigned to the user.
     * @param userName Name of the user.
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(tags: Map<String, String>? = null, userName: String): GetUserResult {
        val argument = GetUserPlainArgs(
            tags = tags,
            userName = userName,
        )
        return getUserResultToKotlin(getUserPlain(argument.toJava()).await())
    }

    /**
     * @see [getUser].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;memorydb&#46;kotlin&#46;inputs&#46;GetUserPlainArgs].
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(argument: suspend GetUserPlainArgsBuilder.() -> Unit): GetUserResult {
        val builder = GetUserPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserResultToKotlin(getUserPlain(builtArgument.toJava()).await())
    }
}
