@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin

import com.pulumi.aws.memorydb.ParameterGroupArgs.builder
import com.pulumi.aws.memorydb.kotlin.inputs.ParameterGroupParameterArgs
import com.pulumi.aws.memorydb.kotlin.inputs.ParameterGroupParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a MemoryDB Parameter Group.
 * More information about parameter groups can be found in the [MemoryDB User Guide](https://docs.aws.amazon.com/memorydb/latest/devguide/parametergroups.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.memorydb.ParameterGroup("example", {
 *     name: "my-parameter-group",
 *     family: "memorydb_redis6",
 *     parameters: [{
 *         name: "activedefrag",
 *         value: "yes",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.memorydb.ParameterGroup("example",
 *     name="my-parameter-group",
 *     family="memorydb_redis6",
 *     parameters=[{
 *         "name": "activedefrag",
 *         "value": "yes",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.MemoryDb.ParameterGroup("example", new()
 *     {
 *         Name = "my-parameter-group",
 *         Family = "memorydb_redis6",
 *         Parameters = new[]
 *         {
 *             new Aws.MemoryDb.Inputs.ParameterGroupParameterArgs
 *             {
 *                 Name = "activedefrag",
 *                 Value = "yes",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/memorydb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := memorydb.NewParameterGroup(ctx, "example", &memorydb.ParameterGroupArgs{
 * 			Name:   pulumi.String("my-parameter-group"),
 * 			Family: pulumi.String("memorydb_redis6"),
 * 			Parameters: memorydb.ParameterGroupParameterArray{
 * 				&memorydb.ParameterGroupParameterArgs{
 * 					Name:  pulumi.String("activedefrag"),
 * 					Value: pulumi.String("yes"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.memorydb.ParameterGroup;
 * import com.pulumi.aws.memorydb.ParameterGroupArgs;
 * import com.pulumi.aws.memorydb.inputs.ParameterGroupParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ParameterGroup("example", ParameterGroupArgs.builder()
 *             .name("my-parameter-group")
 *             .family("memorydb_redis6")
 *             .parameters(ParameterGroupParameterArgs.builder()
 *                 .name("activedefrag")
 *                 .value("yes")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:memorydb:ParameterGroup
 *     properties:
 *       name: my-parameter-group
 *       family: memorydb_redis6
 *       parameters:
 *         - name: activedefrag
 *           value: yes
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a parameter group using the `name`. For example:
 * ```sh
 * $ pulumi import aws:memorydb/parameterGroup:ParameterGroup example my-parameter-group
 * ```
 * @property description Description for the parameter group.
 * @property family The engine version that the parameter group can be used with.
 * The following arguments are optional:
 * @property name Name of the parameter group. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property parameters Set of MemoryDB parameters to apply. Any parameters not specified will fall back to their family defaults. Detailed below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ParameterGroupArgs(
    public val description: Output<String>? = null,
    public val family: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val parameters: Output<List<ParameterGroupParameterArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.memorydb.ParameterGroupArgs> {
    override fun toJava(): com.pulumi.aws.memorydb.ParameterGroupArgs =
        com.pulumi.aws.memorydb.ParameterGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ParameterGroupArgs].
 */
@PulumiTagMarker
public class ParameterGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var family: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var parameters: Output<List<ParameterGroupParameterArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description for the parameter group.
     */
    @JvmName("ddfaqrinldaiemng")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The engine version that the parameter group can be used with.
     * The following arguments are optional:
     */
    @JvmName("pyhbyefkrxgkquds")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value Name of the parameter group. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("fwvwrgrtxuqjjngt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("eadijblxdkjjwvnq")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Set of MemoryDB parameters to apply. Any parameters not specified will fall back to their family defaults. Detailed below.
     */
    @JvmName("skalytdllrteuflh")
    public suspend fun parameters(`value`: Output<List<ParameterGroupParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("ypestkdpqlggxuob")
    public suspend fun parameters(vararg values: Output<ParameterGroupParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Set of MemoryDB parameters to apply. Any parameters not specified will fall back to their family defaults. Detailed below.
     */
    @JvmName("htdblqmviqifjhuc")
    public suspend fun parameters(values: List<Output<ParameterGroupParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("scpxfayloewamuus")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description for the parameter group.
     */
    @JvmName("mgqfqgydwnkbbcpa")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The engine version that the parameter group can be used with.
     * The following arguments are optional:
     */
    @JvmName("obibbvfrgikoqxer")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value Name of the parameter group. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("htshxirvpakmlhrq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("lkvgpvwduipcamup")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Set of MemoryDB parameters to apply. Any parameters not specified will fall back to their family defaults. Detailed below.
     */
    @JvmName("tabwywytlkkfojtu")
    public suspend fun parameters(`value`: List<ParameterGroupParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Set of MemoryDB parameters to apply. Any parameters not specified will fall back to their family defaults. Detailed below.
     */
    @JvmName("xltoqqmkmruifxlo")
    public suspend fun parameters(argument: List<suspend ParameterGroupParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ParameterGroupParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Set of MemoryDB parameters to apply. Any parameters not specified will fall back to their family defaults. Detailed below.
     */
    @JvmName("lnguurrgayofoulc")
    public suspend fun parameters(vararg argument: suspend ParameterGroupParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ParameterGroupParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Set of MemoryDB parameters to apply. Any parameters not specified will fall back to their family defaults. Detailed below.
     */
    @JvmName("ifwvfxxelrdnrtob")
    public suspend fun parameters(argument: suspend ParameterGroupParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ParameterGroupParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Set of MemoryDB parameters to apply. Any parameters not specified will fall back to their family defaults. Detailed below.
     */
    @JvmName("kbsjyyhbqxuwkflh")
    public suspend fun parameters(vararg values: ParameterGroupParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pvkgbxfsfalywpdo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("revntakwjlmpsxkx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ParameterGroupArgs = ParameterGroupArgs(
        description = description,
        family = family,
        name = name,
        namePrefix = namePrefix,
        parameters = parameters,
        tags = tags,
    )
}
