@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin

import com.pulumi.aws.memorydb.SubnetGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a MemoryDB Subnet Group.
 * More information about subnet groups can be found in the [MemoryDB User Guide](https://docs.aws.amazon.com/memorydb/latest/devguide/subnetgroups.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.Vpc("example", {cidrBlock: "10.0.0.0/16"});
 * const exampleSubnet = new aws.ec2.Subnet("example", {
 *     vpcId: example.id,
 *     cidrBlock: "10.0.0.0/24",
 *     availabilityZone: "us-west-2a",
 * });
 * const exampleSubnetGroup = new aws.memorydb.SubnetGroup("example", {
 *     name: "my-subnet-group",
 *     subnetIds: [exampleSubnet&#46;id],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.Vpc("example", cidr_block="10.0.0.0/16")
 * example_subnet = aws.ec2.Subnet("example",
 *     vpc_id=example.id,
 *     cidr_block="10.0.0.0/24",
 *     availability_zone="us-west-2a")
 * example_subnet_group = aws.memorydb.SubnetGroup("example",
 *     name="my-subnet-group",
 *     subnet_ids=[example_subnet&#46;id])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.Vpc("example", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 *     var exampleSubnet = new Aws.Ec2.Subnet("example", new()
 *     {
 *         VpcId = example.Id,
 *         CidrBlock = "10.0.0.0/24",
 *         AvailabilityZone = "us-west-2a",
 *     });
 *     var exampleSubnetGroup = new Aws.MemoryDb.SubnetGroup("example", new()
 *     {
 *         Name = "my-subnet-group",
 *         SubnetIds = new[]
 *         {
 *             exampleSubnet.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/memorydb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2.NewVpc(ctx, "example", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSubnet, err := ec2.NewSubnet(ctx, "example", &ec2.SubnetArgs{
 * 			VpcId:            example.ID(),
 * 			CidrBlock:        pulumi.String("10.0.0.0/24"),
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = memorydb.NewSubnetGroup(ctx, "example", &memorydb.SubnetGroupArgs{
 * 			Name: pulumi.String("my-subnet-group"),
 * 			SubnetIds: pulumi.StringArray{
 * 				exampleSubnet.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.memorydb.SubnetGroup;
 * import com.pulumi.aws.memorydb.SubnetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Vpc("example", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var exampleSubnet = new Subnet("exampleSubnet", SubnetArgs.builder()
 *             .vpcId(example.id())
 *             .cidrBlock("10.0.0.0/24")
 *             .availabilityZone("us-west-2a")
 *             .build());
 *         var exampleSubnetGroup = new SubnetGroup("exampleSubnetGroup", SubnetGroupArgs.builder()
 *             .name("my-subnet-group")
 *             .subnetIds(exampleSubnet.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *   exampleSubnet:
 *     type: aws:ec2:Subnet
 *     name: example
 *     properties:
 *       vpcId: ${example.id}
 *       cidrBlock: 10.0.0.0/24
 *       availabilityZone: us-west-2a
 *   exampleSubnetGroup:
 *     type: aws:memorydb:SubnetGroup
 *     name: example
 *     properties:
 *       name: my-subnet-group
 *       subnetIds:
 *         - ${exampleSubnet.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a subnet group using its `name`. For example:
 * ```sh
 * $ pulumi import aws:memorydb/subnetGroup:SubnetGroup example my-subnet-group
 * ```
 * @property description Description for the subnet group.
 * @property name Name of the subnet group. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property subnetIds Set of VPC Subnet ID-s for the subnet group. At least one subnet must be provided.
 * The following arguments are optional:
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SubnetGroupArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.memorydb.SubnetGroupArgs> {
    override fun toJava(): com.pulumi.aws.memorydb.SubnetGroupArgs =
        com.pulumi.aws.memorydb.SubnetGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SubnetGroupArgs].
 */
@PulumiTagMarker
public class SubnetGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description for the subnet group.
     */
    @JvmName("blausdvkoqxpxayv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the subnet group. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("ypywepdlenwbshdu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("uobehctsqiekdpea")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Set of VPC Subnet ID-s for the subnet group. At least one subnet must be provided.
     * The following arguments are optional:
     */
    @JvmName("jomipltotlxxttoe")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("njoagcshmqnfoirq")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values Set of VPC Subnet ID-s for the subnet group. At least one subnet must be provided.
     * The following arguments are optional:
     */
    @JvmName("hiroqfuvmjeguuko")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rdudeohxhentmdjo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description for the subnet group.
     */
    @JvmName("wuqmtnmmmicjnawm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the subnet group. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("rxiwoudhxmquulay")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("labemmstountypxd")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Set of VPC Subnet ID-s for the subnet group. At least one subnet must be provided.
     * The following arguments are optional:
     */
    @JvmName("hfthssexldvwygho")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values Set of VPC Subnet ID-s for the subnet group. At least one subnet must be provided.
     * The following arguments are optional:
     */
    @JvmName("ocbcpicxwkpfunkc")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ubvedovkrfgfanot")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("oundhnbywshcwrlw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SubnetGroupArgs = SubnetGroupArgs(
        description = description,
        name = name,
        namePrefix = namePrefix,
        subnetIds = subnetIds,
        tags = tags,
    )
}
