@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin

import com.pulumi.aws.memorydb.UserArgs.builder
import com.pulumi.aws.memorydb.kotlin.inputs.UserAuthenticationModeArgs
import com.pulumi.aws.memorydb.kotlin.inputs.UserAuthenticationModeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a MemoryDB User.
 * More information about users and ACL-s can be found in the [MemoryDB User Guide](https://docs.aws.amazon.com/memorydb/latest/devguide/clusters.acls.html).
 * > **Note:** All arguments including the username and passwords will be stored in the raw state as plain-text.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as random from "@pulumi/random";
 * const example = new random.index.Password("example", {length: 16});
 * const exampleUser = new aws.memorydb.User("example", {
 *     userName: "my-user",
 *     accessString: "on ~* &* +@all",
 *     authenticationMode: {
 *         type: "password",
 *         passwords: [example&#46;result],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_random as random
 * example = random.index.Password("example", length=16)
 * example_user = aws.memorydb.User("example",
 *     user_name="my-user",
 *     access_string="on ~* &* +@all",
 *     authentication_mode={
 *         "type": "password",
 *         "passwords": [example["result"]],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Random.Index.Password("example", new()
 *     {
 *         Length = 16,
 *     });
 *     var exampleUser = new Aws.MemoryDb.User("example", new()
 *     {
 *         UserName = "my-user",
 *         AccessString = "on ~* &* +@all",
 *         AuthenticationMode = new Aws.MemoryDb.Inputs.UserAuthenticationModeArgs
 *         {
 *             Type = "password",
 *             Passwords = new[]
 *             {
 *                 example.Result,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/memorydb"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := random.NewPassword(ctx, "example", &random.PasswordArgs{
 * 			Length: 16,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = memorydb.NewUser(ctx, "example", &memorydb.UserArgs{
 * 			UserName:     pulumi.String("my-user"),
 * 			AccessString: pulumi.String("on ~* &* +@all"),
 * 			AuthenticationMode: &memorydb.UserAuthenticationModeArgs{
 * 				Type: pulumi.String("password"),
 * 				Passwords: pulumi.StringArray{
 * 					example.Result,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.password;
 * import com.pulumi.random.PasswordArgs;
 * import com.pulumi.aws.memorydb.User;
 * import com.pulumi.aws.memorydb.UserArgs;
 * import com.pulumi.aws.memorydb.inputs.UserAuthenticationModeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Password("example", PasswordArgs.builder()
 *             .length(16)
 *             .build());
 *         var exampleUser = new User("exampleUser", UserArgs.builder()
 *             .userName("my-user")
 *             .accessString("on ~* &* +@all")
 *             .authenticationMode(UserAuthenticationModeArgs.builder()
 *                 .type("password")
 *                 .passwords(example.result())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: random:password
 *     properties:
 *       length: 16
 *   exampleUser:
 *     type: aws:memorydb:User
 *     name: example
 *     properties:
 *       userName: my-user
 *       accessString: on ~* &* +@all
 *       authenticationMode:
 *         type: password
 *         passwords:
 *           - ${example.result}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a user using the `user_name`. For example:
 * ```sh
 * $ pulumi import aws:memorydb/user:User example my-user
 * ```
 * The `passwords` are not available for imported resources, as this information cannot be read back from the MemoryDB API.
 * @property accessString Access permissions string used for this user.
 * @property authenticationMode Denotes the user's authentication properties. Detailed below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userName Name of the MemoryDB user. Up to 40 characters.
 * The following arguments are optional:
 */
public data class UserArgs(
    public val accessString: Output<String>? = null,
    public val authenticationMode: Output<UserAuthenticationModeArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.memorydb.UserArgs> {
    override fun toJava(): com.pulumi.aws.memorydb.UserArgs =
        com.pulumi.aws.memorydb.UserArgs.builder()
            .accessString(accessString?.applyValue({ args0 -> args0 }))
            .authenticationMode(
                authenticationMode?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserArgs].
 */
@PulumiTagMarker
public class UserArgsBuilder internal constructor() {
    private var accessString: Output<String>? = null

    private var authenticationMode: Output<UserAuthenticationModeArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Access permissions string used for this user.
     */
    @JvmName("xhkgfsuylvolltty")
    public suspend fun accessString(`value`: Output<String>) {
        this.accessString = value
    }

    /**
     * @param value Denotes the user's authentication properties. Detailed below.
     */
    @JvmName("qcyhmqrixqyvncly")
    public suspend fun authenticationMode(`value`: Output<UserAuthenticationModeArgs>) {
        this.authenticationMode = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ximvidkacukhhyho")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the MemoryDB user. Up to 40 characters.
     * The following arguments are optional:
     */
    @JvmName("esouocmgdnvleopn")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Access permissions string used for this user.
     */
    @JvmName("qwfkymmtpccnjvnn")
    public suspend fun accessString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessString = mapped
    }

    /**
     * @param value Denotes the user's authentication properties. Detailed below.
     */
    @JvmName("vocnqxdcaiueevmj")
    public suspend fun authenticationMode(`value`: UserAuthenticationModeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param argument Denotes the user's authentication properties. Detailed below.
     */
    @JvmName("phyyiaktbynuharg")
    public suspend fun authenticationMode(argument: suspend UserAuthenticationModeArgsBuilder.() -> Unit) {
        val toBeMapped = UserAuthenticationModeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authenticationMode = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ccmosfwpvhyfyonh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pmcjssmyvtsuvuls")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of the MemoryDB user. Up to 40 characters.
     * The following arguments are optional:
     */
    @JvmName("nyfocbwrvkmegski")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): UserArgs = UserArgs(
        accessString = accessString,
        authenticationMode = authenticationMode,
        tags = tags,
        userName = userName,
    )
}
