@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.inputs

import com.pulumi.aws.memorydb.inputs.UserAuthenticationModeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property passwordCount Number of passwords belonging to the user if `type` is set to `password`.
 * @property passwords Set of passwords used for authentication if `type` is set to `password`. You can create up to two passwords for each user.
 * @property type Specifies the authentication type. Valid values are: `password` or `iam`.
 */
public data class UserAuthenticationModeArgs(
    public val passwordCount: Output<Int>? = null,
    public val passwords: Output<List<String>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.memorydb.inputs.UserAuthenticationModeArgs> {
    override fun toJava(): com.pulumi.aws.memorydb.inputs.UserAuthenticationModeArgs =
        com.pulumi.aws.memorydb.inputs.UserAuthenticationModeArgs.builder()
            .passwordCount(passwordCount?.applyValue({ args0 -> args0 }))
            .passwords(passwords?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserAuthenticationModeArgs].
 */
@PulumiTagMarker
public class UserAuthenticationModeArgsBuilder internal constructor() {
    private var passwordCount: Output<Int>? = null

    private var passwords: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Number of passwords belonging to the user if `type` is set to `password`.
     */
    @JvmName("esthksuiompalptl")
    public suspend fun passwordCount(`value`: Output<Int>) {
        this.passwordCount = value
    }

    /**
     * @param value Set of passwords used for authentication if `type` is set to `password`. You can create up to two passwords for each user.
     */
    @JvmName("mfwppfpnulpltnuc")
    public suspend fun passwords(`value`: Output<List<String>>) {
        this.passwords = value
    }

    @JvmName("hkfstqnalcfefjqy")
    public suspend fun passwords(vararg values: Output<String>) {
        this.passwords = Output.all(values.asList())
    }

    /**
     * @param values Set of passwords used for authentication if `type` is set to `password`. You can create up to two passwords for each user.
     */
    @JvmName("wwjdjmhsylkumsuc")
    public suspend fun passwords(values: List<Output<String>>) {
        this.passwords = Output.all(values)
    }

    /**
     * @param value Specifies the authentication type. Valid values are: `password` or `iam`.
     */
    @JvmName("ouutntgwejclgoov")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Number of passwords belonging to the user if `type` is set to `password`.
     */
    @JvmName("vhjjuovupxvkbovd")
    public suspend fun passwordCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordCount = mapped
    }

    /**
     * @param value Set of passwords used for authentication if `type` is set to `password`. You can create up to two passwords for each user.
     */
    @JvmName("ipgdijdvkexrplqj")
    public suspend fun passwords(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwords = mapped
    }

    /**
     * @param values Set of passwords used for authentication if `type` is set to `password`. You can create up to two passwords for each user.
     */
    @JvmName("rckrtljgnmestygw")
    public suspend fun passwords(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.passwords = mapped
    }

    /**
     * @param value Specifies the authentication type. Valid values are: `password` or `iam`.
     */
    @JvmName("jkeungjrllhgjvai")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): UserAuthenticationModeArgs = UserAuthenticationModeArgs(
        passwordCount = passwordCount,
        passwords = passwords,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
