@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getAcl.
 * @property arn ARN of the ACL.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property minimumEngineVersion The minimum engine version supported by the ACL.
 * @property name
 * @property tags Map of tags assigned to the ACL.
 * @property userNames Set of MemoryDB user names included in this ACL.
 */
public data class GetAclResult(
    public val arn: String,
    public val id: String,
    public val minimumEngineVersion: String,
    public val name: String,
    public val tags: Map<String, String>,
    public val userNames: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.memorydb.outputs.GetAclResult): GetAclResult =
            GetAclResult(
                arn = javaType.arn(),
                id = javaType.id(),
                minimumEngineVersion = javaType.minimumEngineVersion(),
                name = javaType.name(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                userNames = javaType.userNames().map({ args0 -> args0 }),
            )
    }
}
