@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getParameterGroup.
 * @property arn ARN of the parameter group.
 * @property description Description of the parameter group.
 * @property family Engine version that the parameter group can be used with.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of the parameter.
 * @property parameters Set of user-defined MemoryDB parameters applied by the parameter group.
 * @property tags Map of tags assigned to the parameter group.
 */
public data class GetParameterGroupResult(
    public val arn: String,
    public val description: String,
    public val family: String,
    public val id: String,
    public val name: String,
    public val parameters: List<GetParameterGroupParameter>,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.memorydb.outputs.GetParameterGroupResult): GetParameterGroupResult = GetParameterGroupResult(
            arn = javaType.arn(),
            description = javaType.description(),
            family = javaType.family(),
            id = javaType.id(),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.memorydb.kotlin.outputs.GetParameterGroupParameter.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
