@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description Description for the cluster.
 * @property engineVersion Version number of the Redis engine used by the cluster.
 * @property maintenanceWindow The weekly time range during which maintenance on the cluster is performed.
 * @property name Name of the snapshot.
 * @property nodeType Compute and memory capacity of the nodes in the cluster.
 * @property numShards Number of shards in the cluster.
 * @property parameterGroupName Name of the parameter group associated with the cluster.
 * @property port Port number on which the cluster accepts connections.
 * @property snapshotRetentionLimit Number of days for which MemoryDB retains automatic snapshots before deleting them.
 * @property snapshotWindow The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of the shard.
 * @property subnetGroupName Name of the subnet group used by the cluster.
 * @property topicArn ARN of the SNS topic to which cluster notifications are sent.
 * @property vpcId The VPC in which the cluster exists.
 */
public data class GetSnapshotClusterConfiguration(
    public val description: String,
    public val engineVersion: String,
    public val maintenanceWindow: String,
    public val name: String,
    public val nodeType: String,
    public val numShards: Int,
    public val parameterGroupName: String,
    public val port: Int,
    public val snapshotRetentionLimit: Int,
    public val snapshotWindow: String,
    public val subnetGroupName: String,
    public val topicArn: String,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.memorydb.outputs.GetSnapshotClusterConfiguration): GetSnapshotClusterConfiguration = GetSnapshotClusterConfiguration(
            description = javaType.description(),
            engineVersion = javaType.engineVersion(),
            maintenanceWindow = javaType.maintenanceWindow(),
            name = javaType.name(),
            nodeType = javaType.nodeType(),
            numShards = javaType.numShards(),
            parameterGroupName = javaType.parameterGroupName(),
            port = javaType.port(),
            snapshotRetentionLimit = javaType.snapshotRetentionLimit(),
            snapshotWindow = javaType.snapshotWindow(),
            subnetGroupName = javaType.subnetGroupName(),
            topicArn = javaType.topicArn(),
            vpcId = javaType.vpcId(),
        )
    }
}
