@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getSubnetGroup.
 * @property arn ARN of the subnet group.
 * @property description Description of the subnet group.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property subnetIds Set of VPC Subnet ID-s of the subnet group.
 * @property tags Map of tags assigned to the subnet group.
 * @property vpcId VPC in which the subnet group exists.
 */
public data class GetSubnetGroupResult(
    public val arn: String,
    public val description: String,
    public val id: String,
    public val name: String,
    public val subnetIds: List<String>,
    public val tags: Map<String, String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.memorydb.outputs.GetSubnetGroupResult): GetSubnetGroupResult = GetSubnetGroupResult(
            arn = javaType.arn(),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
        )
    }
}
