@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property passwordCount Number of passwords belonging to the user if `type` is set to `password`.
 * @property type Type of authentication configured.
 */
public data class GetUserAuthenticationMode(
    public val passwordCount: Int,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.memorydb.outputs.GetUserAuthenticationMode): GetUserAuthenticationMode = GetUserAuthenticationMode(
            passwordCount = javaType.passwordCount(),
            type = javaType.type(),
        )
    }
}
