@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getUser.
 * @property accessString Access permissions string used for this user.
 * @property arn ARN of the user.
 * @property authenticationModes Denotes the user's authentication properties.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property minimumEngineVersion Minimum engine version supported for the user.
 * @property tags Map of tags assigned to the user.
 * @property userName
 */
public data class GetUserResult(
    public val accessString: String,
    public val arn: String,
    public val authenticationModes: List<GetUserAuthenticationMode>,
    public val id: String,
    public val minimumEngineVersion: String,
    public val tags: Map<String, String>,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.memorydb.outputs.GetUserResult): GetUserResult =
            GetUserResult(
                accessString = javaType.accessString(),
                arn = javaType.arn(),
                authenticationModes = javaType.authenticationModes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.memorydb.kotlin.outputs.GetUserAuthenticationMode.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                minimumEngineVersion = javaType.minimumEngineVersion(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                userName = javaType.userName(),
            )
    }
}
