@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property passwordCount Number of passwords belonging to the user if `type` is set to `password`.
 * @property passwords Set of passwords used for authentication if `type` is set to `password`. You can create up to two passwords for each user.
 * @property type Specifies the authentication type. Valid values are: `password` or `iam`.
 */
public data class UserAuthenticationMode(
    public val passwordCount: Int? = null,
    public val passwords: List<String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.memorydb.outputs.UserAuthenticationMode): UserAuthenticationMode = UserAuthenticationMode(
            passwordCount = javaType.passwordCount().map({ args0 -> args0 }).orElse(null),
            passwords = javaType.passwords().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
