@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin

import com.pulumi.aws.mq.kotlin.outputs.BrokerConfiguration
import com.pulumi.aws.mq.kotlin.outputs.BrokerEncryptionOptions
import com.pulumi.aws.mq.kotlin.outputs.BrokerInstance
import com.pulumi.aws.mq.kotlin.outputs.BrokerLdapServerMetadata
import com.pulumi.aws.mq.kotlin.outputs.BrokerLogs
import com.pulumi.aws.mq.kotlin.outputs.BrokerMaintenanceWindowStartTime
import com.pulumi.aws.mq.kotlin.outputs.BrokerUser
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.mq.kotlin.outputs.BrokerConfiguration.Companion.toKotlin as brokerConfigurationToKotlin
import com.pulumi.aws.mq.kotlin.outputs.BrokerEncryptionOptions.Companion.toKotlin as brokerEncryptionOptionsToKotlin
import com.pulumi.aws.mq.kotlin.outputs.BrokerInstance.Companion.toKotlin as brokerInstanceToKotlin
import com.pulumi.aws.mq.kotlin.outputs.BrokerLdapServerMetadata.Companion.toKotlin as brokerLdapServerMetadataToKotlin
import com.pulumi.aws.mq.kotlin.outputs.BrokerLogs.Companion.toKotlin as brokerLogsToKotlin
import com.pulumi.aws.mq.kotlin.outputs.BrokerMaintenanceWindowStartTime.Companion.toKotlin as brokerMaintenanceWindowStartTimeToKotlin
import com.pulumi.aws.mq.kotlin.outputs.BrokerUser.Companion.toKotlin as brokerUserToKotlin

/**
 * Builder for [Broker].
 */
@PulumiTagMarker
public class BrokerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BrokerArgs = BrokerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BrokerArgsBuilder.() -> Unit) {
        val builder = BrokerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Broker {
        val builtJavaResource = com.pulumi.aws.mq.Broker(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Broker(builtJavaResource)
    }
}

/**
 * Provides an Amazon MQ broker resource. This resources also manages users for the broker.
 * > For more information on Amazon MQ, see [Amazon MQ documentation](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/welcome.html).
 * > **NOTE:** Amazon MQ currently places limits on **RabbitMQ** brokers. For example, a RabbitMQ broker cannot have: instances with an associated IP address of an ENI attached to the broker, an associated LDAP server to authenticate and authorize broker connections, storage type `EFS`, or audit logging. Although this resource allows you to create RabbitMQ users, RabbitMQ users cannot have console access or groups. Also, Amazon MQ does not return information about RabbitMQ users so drift detection is not possible.
 * > **NOTE:** Changes to an MQ Broker can occur when you change a parameter, such as `configuration` or `user`, and are reflected in the next maintenance window. Because of this, the provider may report a difference in its planning phase because a modification has not yet taken place. You can use the `apply_immediately` flag to instruct the service to apply the change immediately (see documentation below). Using `apply_immediately` can result in a brief downtime as the broker reboots.
 * ## Example Usage
 * ### Basic Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.mq.Broker("example", {
 *     brokerName: "example",
 *     configuration: {
 *         id: test.id,
 *         revision: test.latestRevision,
 *     },
 *     engineType: "ActiveMQ",
 *     engineVersion: "5.17.6",
 *     hostInstanceType: "mq.t2.micro",
 *     securityGroups: [testAwsSecurityGroup&#46;id],
 *     users: [{
 *         username: "ExampleUser",
 *         password: "MindTheGap",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.mq.Broker("example",
 *     broker_name="example",
 *     configuration={
 *         "id": test["id"],
 *         "revision": test["latestRevision"],
 *     },
 *     engine_type="ActiveMQ",
 *     engine_version="5.17.6",
 *     host_instance_type="mq.t2.micro",
 *     security_groups=[test_aws_security_group["id"]],
 *     users=[{
 *         "username": "ExampleUser",
 *         "password": "MindTheGap",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Mq.Broker("example", new()
 *     {
 *         BrokerName = "example",
 *         Configuration = new Aws.Mq.Inputs.BrokerConfigurationArgs
 *         {
 *             Id = test.Id,
 *             Revision = test.LatestRevision,
 *         },
 *         EngineType = "ActiveMQ",
 *         EngineVersion = "5.17.6",
 *         HostInstanceType = "mq.t2.micro",
 *         SecurityGroups = new[]
 *         {
 *             testAwsSecurityGroup.Id,
 *         },
 *         Users = new[]
 *         {
 *             new Aws.Mq.Inputs.BrokerUserArgs
 *             {
 *                 Username = "ExampleUser",
 *                 Password = "MindTheGap",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mq.NewBroker(ctx, "example", &mq.BrokerArgs{
 * 			BrokerName: pulumi.String("example"),
 * 			Configuration: &mq.BrokerConfigurationArgs{
 * 				Id:       pulumi.Any(test.Id),
 * 				Revision: pulumi.Any(test.LatestRevision),
 * 			},
 * 			EngineType:       pulumi.String("ActiveMQ"),
 * 			EngineVersion:    pulumi.String("5.17.6"),
 * 			HostInstanceType: pulumi.String("mq.t2.micro"),
 * 			SecurityGroups: pulumi.StringArray{
 * 				testAwsSecurityGroup.Id,
 * 			},
 * 			Users: mq.BrokerUserArray{
 * 				&mq.BrokerUserArgs{
 * 					Username: pulumi.String("ExampleUser"),
 * 					Password: pulumi.String("MindTheGap"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mq.Broker;
 * import com.pulumi.aws.mq.BrokerArgs;
 * import com.pulumi.aws.mq.inputs.BrokerConfigurationArgs;
 * import com.pulumi.aws.mq.inputs.BrokerUserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Broker("example", BrokerArgs.builder()
 *             .brokerName("example")
 *             .configuration(BrokerConfigurationArgs.builder()
 *                 .id(test.id())
 *                 .revision(test.latestRevision())
 *                 .build())
 *             .engineType("ActiveMQ")
 *             .engineVersion("5.17.6")
 *             .hostInstanceType("mq.t2.micro")
 *             .securityGroups(testAwsSecurityGroup.id())
 *             .users(BrokerUserArgs.builder()
 *                 .username("ExampleUser")
 *                 .password("MindTheGap")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:mq:Broker
 *     properties:
 *       brokerName: example
 *       configuration:
 *         id: ${test.id}
 *         revision: ${test.latestRevision}
 *       engineType: ActiveMQ
 *       engineVersion: 5.17.6
 *       hostInstanceType: mq.t2.micro
 *       securityGroups:
 *         - ${testAwsSecurityGroup.id}
 *       users:
 *         - username: ExampleUser
 *           password: MindTheGap
 * ```
 * <!--End PulumiCodeChooser -->
 * ### High-throughput Optimized Example
 * This example shows the use of EBS storage for high-throughput optimized performance.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.mq.Broker("example", {
 *     brokerName: "example",
 *     configuration: {
 *         id: test.id,
 *         revision: test.latestRevision,
 *     },
 *     engineType: "ActiveMQ",
 *     engineVersion: "5.17.6",
 *     storageType: "ebs",
 *     hostInstanceType: "mq.m5.large",
 *     securityGroups: [testAwsSecurityGroup&#46;id],
 *     users: [{
 *         username: "ExampleUser",
 *         password: "MindTheGap",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.mq.Broker("example",
 *     broker_name="example",
 *     configuration={
 *         "id": test["id"],
 *         "revision": test["latestRevision"],
 *     },
 *     engine_type="ActiveMQ",
 *     engine_version="5.17.6",
 *     storage_type="ebs",
 *     host_instance_type="mq.m5.large",
 *     security_groups=[test_aws_security_group["id"]],
 *     users=[{
 *         "username": "ExampleUser",
 *         "password": "MindTheGap",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Mq.Broker("example", new()
 *     {
 *         BrokerName = "example",
 *         Configuration = new Aws.Mq.Inputs.BrokerConfigurationArgs
 *         {
 *             Id = test.Id,
 *             Revision = test.LatestRevision,
 *         },
 *         EngineType = "ActiveMQ",
 *         EngineVersion = "5.17.6",
 *         StorageType = "ebs",
 *         HostInstanceType = "mq.m5.large",
 *         SecurityGroups = new[]
 *         {
 *             testAwsSecurityGroup.Id,
 *         },
 *         Users = new[]
 *         {
 *             new Aws.Mq.Inputs.BrokerUserArgs
 *             {
 *                 Username = "ExampleUser",
 *                 Password = "MindTheGap",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mq.NewBroker(ctx, "example", &mq.BrokerArgs{
 * 			BrokerName: pulumi.String("example"),
 * 			Configuration: &mq.BrokerConfigurationArgs{
 * 				Id:       pulumi.Any(test.Id),
 * 				Revision: pulumi.Any(test.LatestRevision),
 * 			},
 * 			EngineType:       pulumi.String("ActiveMQ"),
 * 			EngineVersion:    pulumi.String("5.17.6"),
 * 			StorageType:      pulumi.String("ebs"),
 * 			HostInstanceType: pulumi.String("mq.m5.large"),
 * 			SecurityGroups: pulumi.StringArray{
 * 				testAwsSecurityGroup.Id,
 * 			},
 * 			Users: mq.BrokerUserArray{
 * 				&mq.BrokerUserArgs{
 * 					Username: pulumi.String("ExampleUser"),
 * 					Password: pulumi.String("MindTheGap"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mq.Broker;
 * import com.pulumi.aws.mq.BrokerArgs;
 * import com.pulumi.aws.mq.inputs.BrokerConfigurationArgs;
 * import com.pulumi.aws.mq.inputs.BrokerUserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Broker("example", BrokerArgs.builder()
 *             .brokerName("example")
 *             .configuration(BrokerConfigurationArgs.builder()
 *                 .id(test.id())
 *                 .revision(test.latestRevision())
 *                 .build())
 *             .engineType("ActiveMQ")
 *             .engineVersion("5.17.6")
 *             .storageType("ebs")
 *             .hostInstanceType("mq.m5.large")
 *             .securityGroups(testAwsSecurityGroup.id())
 *             .users(BrokerUserArgs.builder()
 *                 .username("ExampleUser")
 *                 .password("MindTheGap")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:mq:Broker
 *     properties:
 *       brokerName: example
 *       configuration:
 *         id: ${test.id}
 *         revision: ${test.latestRevision}
 *       engineType: ActiveMQ
 *       engineVersion: 5.17.6
 *       storageType: ebs
 *       hostInstanceType: mq.m5.large
 *       securityGroups:
 *         - ${testAwsSecurityGroup.id}
 *       users:
 *         - username: ExampleUser
 *           password: MindTheGap
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Cross-Region Data Replication
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const examplePrimary = new aws.mq.Broker("example_primary", {
 *     applyImmediately: true,
 *     brokerName: "example_primary",
 *     engineType: "ActiveMQ",
 *     engineVersion: "5.17.6",
 *     hostInstanceType: "mq.m5.large",
 *     securityGroups: [examplePrimaryAwsSecurityGroup&#46;id],
 *     deploymentMode: "ACTIVE_STANDBY_MULTI_AZ",
 *     users: [
 *         {
 *             username: "ExampleUser",
 *             password: "MindTheGap",
 *         },
 *         {
 *             username: "ExampleReplicationUser",
 *             password: "Example12345",
 *             replicationUser: true,
 *         },
 *     ],
 * });
 * const example = new aws.mq.Broker("example", {
 *     applyImmediately: true,
 *     brokerName: "example",
 *     engineType: "ActiveMQ",
 *     engineVersion: "5.17.6",
 *     hostInstanceType: "mq.m5.large",
 *     securityGroups: [exampleAwsSecurityGroup&#46;id],
 *     deploymentMode: "ACTIVE_STANDBY_MULTI_AZ",
 *     dataReplicationMode: "CRDR",
 *     dataReplicationPrimaryBrokerArn: primary.arn,
 *     users: [
 *         {
 *             username: "ExampleUser",
 *             password: "MindTheGap",
 *         },
 *         {
 *             username: "ExampleReplicationUser",
 *             password: "Example12345",
 *             replicationUser: true,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_primary = aws.mq.Broker("example_primary",
 *     apply_immediately=True,
 *     broker_name="example_primary",
 *     engine_type="ActiveMQ",
 *     engine_version="5.17.6",
 *     host_instance_type="mq.m5.large",
 *     security_groups=[example_primary_aws_security_group["id"]],
 *     deployment_mode="ACTIVE_STANDBY_MULTI_AZ",
 *     users=[
 *         {
 *             "username": "ExampleUser",
 *             "password": "MindTheGap",
 *         },
 *         {
 *             "username": "ExampleReplicationUser",
 *             "password": "Example12345",
 *             "replication_user": True,
 *         },
 *     ])
 * example = aws.mq.Broker("example",
 *     apply_immediately=True,
 *     broker_name="example",
 *     engine_type="ActiveMQ",
 *     engine_version="5.17.6",
 *     host_instance_type="mq.m5.large",
 *     security_groups=[example_aws_security_group["id"]],
 *     deployment_mode="ACTIVE_STANDBY_MULTI_AZ",
 *     data_replication_mode="CRDR",
 *     data_replication_primary_broker_arn=primary["arn"],
 *     users=[
 *         {
 *             "username": "ExampleUser",
 *             "password": "MindTheGap",
 *         },
 *         {
 *             "username": "ExampleReplicationUser",
 *             "password": "Example12345",
 *             "replication_user": True,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var examplePrimary = new Aws.Mq.Broker("example_primary", new()
 *     {
 *         ApplyImmediately = true,
 *         BrokerName = "example_primary",
 *         EngineType = "ActiveMQ",
 *         EngineVersion = "5.17.6",
 *         HostInstanceType = "mq.m5.large",
 *         SecurityGroups = new[]
 *         {
 *             examplePrimaryAwsSecurityGroup.Id,
 *         },
 *         DeploymentMode = "ACTIVE_STANDBY_MULTI_AZ",
 *         Users = new[]
 *         {
 *             new Aws.Mq.Inputs.BrokerUserArgs
 *             {
 *                 Username = "ExampleUser",
 *                 Password = "MindTheGap",
 *             },
 *             new Aws.Mq.Inputs.BrokerUserArgs
 *             {
 *                 Username = "ExampleReplicationUser",
 *                 Password = "Example12345",
 *                 ReplicationUser = true,
 *             },
 *         },
 *     });
 *     var example = new Aws.Mq.Broker("example", new()
 *     {
 *         ApplyImmediately = true,
 *         BrokerName = "example",
 *         EngineType = "ActiveMQ",
 *         EngineVersion = "5.17.6",
 *         HostInstanceType = "mq.m5.large",
 *         SecurityGroups = new[]
 *         {
 *             exampleAwsSecurityGroup.Id,
 *         },
 *         DeploymentMode = "ACTIVE_STANDBY_MULTI_AZ",
 *         DataReplicationMode = "CRDR",
 *         DataReplicationPrimaryBrokerArn = primary.Arn,
 *         Users = new[]
 *         {
 *             new Aws.Mq.Inputs.BrokerUserArgs
 *             {
 *                 Username = "ExampleUser",
 *                 Password = "MindTheGap",
 *             },
 *             new Aws.Mq.Inputs.BrokerUserArgs
 *             {
 *                 Username = "ExampleReplicationUser",
 *                 Password = "Example12345",
 *                 ReplicationUser = true,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mq.NewBroker(ctx, "example_primary", &mq.BrokerArgs{
 * 			ApplyImmediately: pulumi.Bool(true),
 * 			BrokerName:       pulumi.String("example_primary"),
 * 			EngineType:       pulumi.String("ActiveMQ"),
 * 			EngineVersion:    pulumi.String("5.17.6"),
 * 			HostInstanceType: pulumi.String("mq.m5.large"),
 * 			SecurityGroups: pulumi.StringArray{
 * 				examplePrimaryAwsSecurityGroup.Id,
 * 			},
 * 			DeploymentMode: pulumi.String("ACTIVE_STANDBY_MULTI_AZ"),
 * 			Users: mq.BrokerUserArray{
 * 				&mq.BrokerUserArgs{
 * 					Username: pulumi.String("ExampleUser"),
 * 					Password: pulumi.String("MindTheGap"),
 * 				},
 * 				&mq.BrokerUserArgs{
 * 					Username:        pulumi.String("ExampleReplicationUser"),
 * 					Password:        pulumi.String("Example12345"),
 * 					ReplicationUser: pulumi.Bool(true),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = mq.NewBroker(ctx, "example", &mq.BrokerArgs{
 * 			ApplyImmediately: pulumi.Bool(true),
 * 			BrokerName:       pulumi.String("example"),
 * 			EngineType:       pulumi.String("ActiveMQ"),
 * 			EngineVersion:    pulumi.String("5.17.6"),
 * 			HostInstanceType: pulumi.String("mq.m5.large"),
 * 			SecurityGroups: pulumi.StringArray{
 * 				exampleAwsSecurityGroup.Id,
 * 			},
 * 			DeploymentMode:                  pulumi.String("ACTIVE_STANDBY_MULTI_AZ"),
 * 			DataReplicationMode:             pulumi.String("CRDR"),
 * 			DataReplicationPrimaryBrokerArn: pulumi.Any(primary.Arn),
 * 			Users: mq.BrokerUserArray{
 * 				&mq.BrokerUserArgs{
 * 					Username: pulumi.String("ExampleUser"),
 * 					Password: pulumi.String("MindTheGap"),
 * 				},
 * 				&mq.BrokerUserArgs{
 * 					Username:        pulumi.String("ExampleReplicationUser"),
 * 					Password:        pulumi.String("Example12345"),
 * 					ReplicationUser: pulumi.Bool(true),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mq.Broker;
 * import com.pulumi.aws.mq.BrokerArgs;
 * import com.pulumi.aws.mq.inputs.BrokerUserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var examplePrimary = new Broker("examplePrimary", BrokerArgs.builder()
 *             .applyImmediately(true)
 *             .brokerName("example_primary")
 *             .engineType("ActiveMQ")
 *             .engineVersion("5.17.6")
 *             .hostInstanceType("mq.m5.large")
 *             .securityGroups(examplePrimaryAwsSecurityGroup.id())
 *             .deploymentMode("ACTIVE_STANDBY_MULTI_AZ")
 *             .users(
 *                 BrokerUserArgs.builder()
 *                     .username("ExampleUser")
 *                     .password("MindTheGap")
 *                     .build(),
 *                 BrokerUserArgs.builder()
 *                     .username("ExampleReplicationUser")
 *                     .password("Example12345")
 *                     .replicationUser(true)
 *                     .build())
 *             .build());
 *         var example = new Broker("example", BrokerArgs.builder()
 *             .applyImmediately(true)
 *             .brokerName("example")
 *             .engineType("ActiveMQ")
 *             .engineVersion("5.17.6")
 *             .hostInstanceType("mq.m5.large")
 *             .securityGroups(exampleAwsSecurityGroup.id())
 *             .deploymentMode("ACTIVE_STANDBY_MULTI_AZ")
 *             .dataReplicationMode("CRDR")
 *             .dataReplicationPrimaryBrokerArn(primary.arn())
 *             .users(
 *                 BrokerUserArgs.builder()
 *                     .username("ExampleUser")
 *                     .password("MindTheGap")
 *                     .build(),
 *                 BrokerUserArgs.builder()
 *                     .username("ExampleReplicationUser")
 *                     .password("Example12345")
 *                     .replicationUser(true)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   examplePrimary:
 *     type: aws:mq:Broker
 *     name: example_primary
 *     properties:
 *       applyImmediately: true
 *       brokerName: example_primary
 *       engineType: ActiveMQ
 *       engineVersion: 5.17.6
 *       hostInstanceType: mq.m5.large
 *       securityGroups:
 *         - ${examplePrimaryAwsSecurityGroup.id}
 *       deploymentMode: ACTIVE_STANDBY_MULTI_AZ
 *       users:
 *         - username: ExampleUser
 *           password: MindTheGap
 *         - username: ExampleReplicationUser
 *           password: Example12345
 *           replicationUser: true
 *   example:
 *     type: aws:mq:Broker
 *     properties:
 *       applyImmediately: true
 *       brokerName: example
 *       engineType: ActiveMQ
 *       engineVersion: 5.17.6
 *       hostInstanceType: mq.m5.large
 *       securityGroups:
 *         - ${exampleAwsSecurityGroup.id}
 *       deploymentMode: ACTIVE_STANDBY_MULTI_AZ
 *       dataReplicationMode: CRDR
 *       dataReplicationPrimaryBrokerArn: ${primary.arn}
 *       users:
 *         - username: ExampleUser
 *           password: MindTheGap
 *         - username: ExampleReplicationUser
 *           password: Example12345
 *           replicationUser: true
 * ```
 * <!--End PulumiCodeChooser -->
 * See the [AWS MQ documentation](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/crdr-for-active-mq.html) on cross-region data replication for additional details.
 * ## Import
 * Using `pulumi import`, import MQ Brokers using their broker id. For example:
 * ```sh
 * $ pulumi import aws:mq/broker:Broker example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 */
public class Broker internal constructor(
    override val javaResource: com.pulumi.aws.mq.Broker,
) : KotlinCustomResource(javaResource, BrokerMapper) {
    /**
     * Specifies whether any broker modifications are applied immediately, or during the next maintenance window. Default is `false`.
     */
    public val applyImmediately: Output<Boolean>?
        get() = javaResource.applyImmediately().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the broker.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Authentication strategy used to secure the broker. Valid values are `simple` and `ldap`. `ldap` is not supported for `engine_type` `RabbitMQ`.
     */
    public val authenticationStrategy: Output<String>
        get() = javaResource.authenticationStrategy().applyValue({ args0 -> args0 })

    /**
     * Whether to automatically upgrade to new minor versions of brokers as Amazon MQ makes releases available.
     */
    public val autoMinorVersionUpgrade: Output<Boolean>?
        get() = javaResource.autoMinorVersionUpgrade().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the broker.
     */
    public val brokerName: Output<String>
        get() = javaResource.brokerName().applyValue({ args0 -> args0 })

    /**
     * Configuration block for broker configuration. Applies to `engine_type` of `ActiveMQ` and `RabbitMQ` only. Detailed below.
     */
    public val configuration: Output<BrokerConfiguration>
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.let({ args0 ->
                brokerConfigurationToKotlin(args0)
            })
        })

    /**
     * Defines whether this broker is a part of a data replication pair. Valid values are `CRDR` and `NONE`.
     */
    public val dataReplicationMode: Output<String>
        get() = javaResource.dataReplicationMode().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the primary broker that is used to replicate data from in a data replication pair, and is applied to the replica broker. Must be set when `data_replication_mode` is `CRDR`.
     */
    public val dataReplicationPrimaryBrokerArn: Output<String>?
        get() = javaResource.dataReplicationPrimaryBrokerArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Deployment mode of the broker. Valid values are `SINGLE_INSTANCE`, `ACTIVE_STANDBY_MULTI_AZ`, and `CLUSTER_MULTI_AZ`. Default is `SINGLE_INSTANCE`.
     */
    public val deploymentMode: Output<String>?
        get() = javaResource.deploymentMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block containing encryption options. Detailed below.
     */
    public val encryptionOptions: Output<BrokerEncryptionOptions>?
        get() = javaResource.encryptionOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> brokerEncryptionOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Type of broker engine. Valid values are `ActiveMQ` and `RabbitMQ`.
     */
    public val engineType: Output<String>
        get() = javaResource.engineType().applyValue({ args0 -> args0 })

    /**
     * Version of the broker engine. See the [AmazonMQ Broker Engine docs](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html) for supported versions. For example, `5.17.6`.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * Broker's instance type. For example, `mq.t3.micro`, `mq.m5.large`.
     */
    public val hostInstanceType: Output<String>
        get() = javaResource.hostInstanceType().applyValue({ args0 -> args0 })

    /**
     * List of information about allocated brokers (both active & standby).
     */
    public val instances: Output<List<BrokerInstance>>
        get() = javaResource.instances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    brokerInstanceToKotlin(args0)
                })
            })
        })

    /**
     * Configuration block for the LDAP server used to authenticate and authorize connections to the broker. Not supported for `engine_type` `RabbitMQ`. Detailed below. (Currently, AWS may not process changes to LDAP server metadata.)
     */
    public val ldapServerMetadata: Output<BrokerLdapServerMetadata>?
        get() = javaResource.ldapServerMetadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> brokerLdapServerMetadataToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Configuration block for the logging configuration of the broker. Detailed below.
     */
    public val logs: Output<BrokerLogs>?
        get() = javaResource.logs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    brokerLogsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Configuration block for the maintenance window start time. Detailed below.
     */
    public val maintenanceWindowStartTime: Output<BrokerMaintenanceWindowStartTime>
        get() = javaResource.maintenanceWindowStartTime().applyValue({ args0 ->
            args0.let({ args0 ->
                brokerMaintenanceWindowStartTimeToKotlin(args0)
            })
        })

    /**
     * (Optional) The data replication mode that will be applied after reboot.
     */
    public val pendingDataReplicationMode: Output<String>
        get() = javaResource.pendingDataReplicationMode().applyValue({ args0 -> args0 })

    /**
     * Whether to enable connections from applications outside of the VPC that hosts the broker's subnets.
     */
    public val publiclyAccessible: Output<Boolean>?
        get() = javaResource.publiclyAccessible().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of security group IDs assigned to the broker.
     */
    public val securityGroups: Output<List<String>>?
        get() = javaResource.securityGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Storage type of the broker. For `engine_type` `ActiveMQ`, the valid values are `efs` and `ebs`, and the AWS-default is `efs`. For `engine_type` `RabbitMQ`, only `ebs` is supported. When using `ebs`, only the `mq.m5` broker instance type family is supported.
     */
    public val storageType: Output<String>
        get() = javaResource.storageType().applyValue({ args0 -> args0 })

    /**
     * List of subnet IDs in which to launch the broker. A `SINGLE_INSTANCE` deployment requires one subnet. An `ACTIVE_STANDBY_MULTI_AZ` deployment requires multiple subnets.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Map of tags to assign to the broker. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block for broker users. For `engine_type` of `RabbitMQ`, Amazon MQ does not return broker users preventing this resource from making user updates and drift detection. Detailed below.
     * The following arguments are optional:
     */
    public val users: Output<List<BrokerUser>>
        get() = javaResource.users().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    brokerUserToKotlin(args0)
                })
            })
        })
}

public object BrokerMapper : ResourceMapper<Broker> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.mq.Broker::class == javaResource::class

    override fun map(javaResource: Resource): Broker = Broker(
        javaResource as
            com.pulumi.aws.mq.Broker,
    )
}

/**
 * @see [Broker].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Broker].
 */
public suspend fun broker(name: String, block: suspend BrokerResourceBuilder.() -> Unit): Broker {
    val builder = BrokerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Broker].
 * @param name The _unique_ name of the resulting resource.
 */
public fun broker(name: String): Broker {
    val builder = BrokerResourceBuilder()
    builder.name(name)
    return builder.build()
}
