@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Configuration].
 */
@PulumiTagMarker
public class ConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationArgs = ConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationArgsBuilder.() -> Unit) {
        val builder = ConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Configuration {
        val builtJavaResource = com.pulumi.aws.mq.Configuration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Configuration(builtJavaResource)
    }
}

/**
 * Provides an MQ Configuration Resource.
 * For more information on Amazon MQ, see [Amazon MQ documentation](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/welcome.html).
 * ## Example Usage
 * ### ActiveMQ
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.mq.Configuration("example", {
 *     description: "Example Configuration",
 *     name: "example",
 *     engineType: "ActiveMQ",
 *     engineVersion: "5.17.6",
 *     data: `<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
 * <broker xmlns="http://activemq.apache.org/schema/core">
 *   <plugins>
 *     <forcePersistencyModeBrokerPlugin persistenceFlag="true"/>
 *     <statisticsBrokerPlugin/>
 *     <timeStampingBrokerPlugin ttlCeiling="86400000" zeroExpirationOverride="86400000"/>
 *   </plugins>
 * </broker>
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.mq.Configuration("example",
 *     description="Example Configuration",
 *     name="example",
 *     engine_type="ActiveMQ",
 *     engine_version="5.17.6",
 *     data="""<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
 * <broker xmlns="http://activemq.apache.org/schema/core">
 *   <plugins>
 *     <forcePersistencyModeBrokerPlugin persistenceFlag="true"/>
 *     <statisticsBrokerPlugin/>
 *     <timeStampingBrokerPlugin ttlCeiling="86400000" zeroExpirationOverride="86400000"/>
 *   </plugins>
 * </broker>
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Mq.Configuration("example", new()
 *     {
 *         Description = "Example Configuration",
 *         Name = "example",
 *         EngineType = "ActiveMQ",
 *         EngineVersion = "5.17.6",
 *         Data = @"<?xml version=""1.0"" encoding=""UTF-8"" standalone=""yes""?>
 * <broker xmlns=""http://activemq.apache.org/schema/core"">
 *   <plugins>
 *     <forcePersistencyModeBrokerPlugin persistenceFlag=""true""/>
 *     <statisticsBrokerPlugin/>
 *     <timeStampingBrokerPlugin ttlCeiling=""86400000"" zeroExpirationOverride=""86400000""/>
 *   </plugins>
 * </broker>
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mq.NewConfiguration(ctx, "example", &mq.ConfigurationArgs{
 * 			Description:   pulumi.String("Example Configuration"),
 * 			Name:          pulumi.String("example"),
 * 			EngineType:    pulumi.String("ActiveMQ"),
 * 			EngineVersion: pulumi.String("5.17.6"),
 * 			Data: pulumi.String(`<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
 * <broker xmlns="http://activemq.apache.org/schema/core">
 *   <plugins>
 *     <forcePersistencyModeBrokerPlugin persistenceFlag="true"/>
 *     <statisticsBrokerPlugin/>
 *     <timeStampingBrokerPlugin ttlCeiling="86400000" zeroExpirationOverride="86400000"/>
 *   </plugins>
 * </broker>
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mq.Configuration;
 * import com.pulumi.aws.mq.ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Configuration("example", ConfigurationArgs.builder()
 *             .description("Example Configuration")
 *             .name("example")
 *             .engineType("ActiveMQ")
 *             .engineVersion("5.17.6")
 *             .data("""
 * <?xml version="1.0" encoding="UTF-8" standalone="yes"?>
 * <broker xmlns="http://activemq.apache.org/schema/core">
 *   <plugins>
 *     <forcePersistencyModeBrokerPlugin persistenceFlag="true"/>
 *     <statisticsBrokerPlugin/>
 *     <timeStampingBrokerPlugin ttlCeiling="86400000" zeroExpirationOverride="86400000"/>
 *   </plugins>
 * </broker>
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:mq:Configuration
 *     properties:
 *       description: Example Configuration
 *       name: example
 *       engineType: ActiveMQ
 *       engineVersion: 5.17.6
 *       data: |
 *         <?xml version="1.0" encoding="UTF-8" standalone="yes"?>
 *         <broker xmlns="http://activemq.apache.org/schema/core">
 *           <plugins>
 *             <forcePersistencyModeBrokerPlugin persistenceFlag="true"/>
 *             <statisticsBrokerPlugin/>
 *             <timeStampingBrokerPlugin ttlCeiling="86400000" zeroExpirationOverride="86400000"/>
 *           </plugins>
 *         </broker>
 * ```
 * <!--End PulumiCodeChooser -->
 * ### RabbitMQ
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.mq.Configuration("example", {
 *     description: "Example Configuration",
 *     name: "example",
 *     engineType: "RabbitMQ",
 *     engineVersion: "3.11.20",
 *     data: `# Default RabbitMQ delivery acknowledgement timeout is 30 minutes in milliseconds
 * consumer_timeout = 1800000
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.mq.Configuration("example",
 *     description="Example Configuration",
 *     name="example",
 *     engine_type="RabbitMQ",
 *     engine_version="3.11.20",
 *     data="""# Default RabbitMQ delivery acknowledgement timeout is 30 minutes in milliseconds
 * consumer_timeout = 1800000
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Mq.Configuration("example", new()
 *     {
 *         Description = "Example Configuration",
 *         Name = "example",
 *         EngineType = "RabbitMQ",
 *         EngineVersion = "3.11.20",
 *         Data = @"# Default RabbitMQ delivery acknowledgement timeout is 30 minutes in milliseconds
 * consumer_timeout = 1800000
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mq.NewConfiguration(ctx, "example", &mq.ConfigurationArgs{
 * 			Description:   pulumi.String("Example Configuration"),
 * 			Name:          pulumi.String("example"),
 * 			EngineType:    pulumi.String("RabbitMQ"),
 * 			EngineVersion: pulumi.String("3.11.20"),
 * 			Data:          pulumi.String("# Default RabbitMQ delivery acknowledgement timeout is 30 minutes in milliseconds\nconsumer_timeout = 1800000\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mq.Configuration;
 * import com.pulumi.aws.mq.ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Configuration("example", ConfigurationArgs.builder()
 *             .description("Example Configuration")
 *             .name("example")
 *             .engineType("RabbitMQ")
 *             .engineVersion("3.11.20")
 *             .data("""
 * # Default RabbitMQ delivery acknowledgement timeout is 30 minutes in milliseconds
 * consumer_timeout = 1800000
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:mq:Configuration
 *     properties:
 *       description: Example Configuration
 *       name: example
 *       engineType: RabbitMQ
 *       engineVersion: 3.11.20
 *       data: |
 *         # Default RabbitMQ delivery acknowledgement timeout is 30 minutes in milliseconds
 *         consumer_timeout = 1800000
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MQ Configurations using the configuration ID. For example:
 * ```sh
 * $ pulumi import aws:mq/configuration:Configuration example c-0187d1eb-88c8-475a-9b79-16ef5a10c94f
 * ```
 */
public class Configuration internal constructor(
    override val javaResource: com.pulumi.aws.mq.Configuration,
) : KotlinCustomResource(javaResource, ConfigurationMapper) {
    /**
     * ARN of the configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Authentication strategy associated with the configuration. Valid values are `simple` and `ldap`. `ldap` is not supported for `engine_type` `RabbitMQ`.
     */
    public val authenticationStrategy: Output<String>
        get() = javaResource.authenticationStrategy().applyValue({ args0 -> args0 })

    /**
     * Broker configuration in XML format for `ActiveMQ` or [Cuttlefish](https://github&#46;com/Kyorai/cuttlefish) format for `RabbitMQ`&#46; See [official docs](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/amazon-mq-broker-configuration-parameters.html) for supported parameters and format of the XML.
     */
    public val `data`: Output<String>
        get() = javaResource.`data`().applyValue({ args0 -> args0 })

    /**
     * Description of the configuration.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of broker engine. Valid values are `ActiveMQ` and `RabbitMQ`.
     */
    public val engineType: Output<String>
        get() = javaResource.engineType().applyValue({ args0 -> args0 })

    /**
     * Version of the broker engine.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * Latest revision of the configuration.
     */
    public val latestRevision: Output<Int>
        get() = javaResource.latestRevision().applyValue({ args0 -> args0 })

    /**
     * Name of the configuration.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ConfigurationMapper : ResourceMapper<Configuration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.mq.Configuration::class == javaResource::class

    override fun map(javaResource: Resource): Configuration = Configuration(
        javaResource as
            com.pulumi.aws.mq.Configuration,
    )
}

/**
 * @see [Configuration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Configuration].
 */
public suspend fun configuration(
    name: String,
    block: suspend ConfigurationResourceBuilder.() -> Unit,
): Configuration {
    val builder = ConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Configuration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configuration(name: String): Configuration {
    val builder = ConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
