@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin

import com.pulumi.aws.mq.ConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an MQ Configuration Resource.
 * For more information on Amazon MQ, see [Amazon MQ documentation](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/welcome.html).
 * ## Example Usage
 * ### ActiveMQ
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.mq.Configuration("example", {
 *     description: "Example Configuration",
 *     name: "example",
 *     engineType: "ActiveMQ",
 *     engineVersion: "5.17.6",
 *     data: `<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
 * <broker xmlns="http://activemq.apache.org/schema/core">
 *   <plugins>
 *     <forcePersistencyModeBrokerPlugin persistenceFlag="true"/>
 *     <statisticsBrokerPlugin/>
 *     <timeStampingBrokerPlugin ttlCeiling="86400000" zeroExpirationOverride="86400000"/>
 *   </plugins>
 * </broker>
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.mq.Configuration("example",
 *     description="Example Configuration",
 *     name="example",
 *     engine_type="ActiveMQ",
 *     engine_version="5.17.6",
 *     data="""<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
 * <broker xmlns="http://activemq.apache.org/schema/core">
 *   <plugins>
 *     <forcePersistencyModeBrokerPlugin persistenceFlag="true"/>
 *     <statisticsBrokerPlugin/>
 *     <timeStampingBrokerPlugin ttlCeiling="86400000" zeroExpirationOverride="86400000"/>
 *   </plugins>
 * </broker>
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Mq.Configuration("example", new()
 *     {
 *         Description = "Example Configuration",
 *         Name = "example",
 *         EngineType = "ActiveMQ",
 *         EngineVersion = "5.17.6",
 *         Data = @"<?xml version=""1.0"" encoding=""UTF-8"" standalone=""yes""?>
 * <broker xmlns=""http://activemq.apache.org/schema/core"">
 *   <plugins>
 *     <forcePersistencyModeBrokerPlugin persistenceFlag=""true""/>
 *     <statisticsBrokerPlugin/>
 *     <timeStampingBrokerPlugin ttlCeiling=""86400000"" zeroExpirationOverride=""86400000""/>
 *   </plugins>
 * </broker>
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mq.NewConfiguration(ctx, "example", &mq.ConfigurationArgs{
 * 			Description:   pulumi.String("Example Configuration"),
 * 			Name:          pulumi.String("example"),
 * 			EngineType:    pulumi.String("ActiveMQ"),
 * 			EngineVersion: pulumi.String("5.17.6"),
 * 			Data: pulumi.String(`<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
 * <broker xmlns="http://activemq.apache.org/schema/core">
 *   <plugins>
 *     <forcePersistencyModeBrokerPlugin persistenceFlag="true"/>
 *     <statisticsBrokerPlugin/>
 *     <timeStampingBrokerPlugin ttlCeiling="86400000" zeroExpirationOverride="86400000"/>
 *   </plugins>
 * </broker>
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mq.Configuration;
 * import com.pulumi.aws.mq.ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Configuration("example", ConfigurationArgs.builder()
 *             .description("Example Configuration")
 *             .name("example")
 *             .engineType("ActiveMQ")
 *             .engineVersion("5.17.6")
 *             .data("""
 * <?xml version="1.0" encoding="UTF-8" standalone="yes"?>
 * <broker xmlns="http://activemq.apache.org/schema/core">
 *   <plugins>
 *     <forcePersistencyModeBrokerPlugin persistenceFlag="true"/>
 *     <statisticsBrokerPlugin/>
 *     <timeStampingBrokerPlugin ttlCeiling="86400000" zeroExpirationOverride="86400000"/>
 *   </plugins>
 * </broker>
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:mq:Configuration
 *     properties:
 *       description: Example Configuration
 *       name: example
 *       engineType: ActiveMQ
 *       engineVersion: 5.17.6
 *       data: |
 *         <?xml version="1.0" encoding="UTF-8" standalone="yes"?>
 *         <broker xmlns="http://activemq.apache.org/schema/core">
 *           <plugins>
 *             <forcePersistencyModeBrokerPlugin persistenceFlag="true"/>
 *             <statisticsBrokerPlugin/>
 *             <timeStampingBrokerPlugin ttlCeiling="86400000" zeroExpirationOverride="86400000"/>
 *           </plugins>
 *         </broker>
 * ```
 * <!--End PulumiCodeChooser -->
 * ### RabbitMQ
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.mq.Configuration("example", {
 *     description: "Example Configuration",
 *     name: "example",
 *     engineType: "RabbitMQ",
 *     engineVersion: "3.11.20",
 *     data: `# Default RabbitMQ delivery acknowledgement timeout is 30 minutes in milliseconds
 * consumer_timeout = 1800000
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.mq.Configuration("example",
 *     description="Example Configuration",
 *     name="example",
 *     engine_type="RabbitMQ",
 *     engine_version="3.11.20",
 *     data="""# Default RabbitMQ delivery acknowledgement timeout is 30 minutes in milliseconds
 * consumer_timeout = 1800000
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Mq.Configuration("example", new()
 *     {
 *         Description = "Example Configuration",
 *         Name = "example",
 *         EngineType = "RabbitMQ",
 *         EngineVersion = "3.11.20",
 *         Data = @"# Default RabbitMQ delivery acknowledgement timeout is 30 minutes in milliseconds
 * consumer_timeout = 1800000
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mq.NewConfiguration(ctx, "example", &mq.ConfigurationArgs{
 * 			Description:   pulumi.String("Example Configuration"),
 * 			Name:          pulumi.String("example"),
 * 			EngineType:    pulumi.String("RabbitMQ"),
 * 			EngineVersion: pulumi.String("3.11.20"),
 * 			Data:          pulumi.String("# Default RabbitMQ delivery acknowledgement timeout is 30 minutes in milliseconds\nconsumer_timeout = 1800000\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mq.Configuration;
 * import com.pulumi.aws.mq.ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Configuration("example", ConfigurationArgs.builder()
 *             .description("Example Configuration")
 *             .name("example")
 *             .engineType("RabbitMQ")
 *             .engineVersion("3.11.20")
 *             .data("""
 * # Default RabbitMQ delivery acknowledgement timeout is 30 minutes in milliseconds
 * consumer_timeout = 1800000
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:mq:Configuration
 *     properties:
 *       description: Example Configuration
 *       name: example
 *       engineType: RabbitMQ
 *       engineVersion: 3.11.20
 *       data: |
 *         # Default RabbitMQ delivery acknowledgement timeout is 30 minutes in milliseconds
 *         consumer_timeout = 1800000
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MQ Configurations using the configuration ID. For example:
 * ```sh
 * $ pulumi import aws:mq/configuration:Configuration example c-0187d1eb-88c8-475a-9b79-16ef5a10c94f
 * ```
 * @property authenticationStrategy Authentication strategy associated with the configuration. Valid values are `simple` and `ldap`. `ldap` is not supported for `engine_type` `RabbitMQ`.
 * @property data Broker configuration in XML format for `ActiveMQ` or [Cuttlefish](https://github&#46;com/Kyorai/cuttlefish) format for `RabbitMQ`&#46; See [official docs](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/amazon-mq-broker-configuration-parameters.html) for supported parameters and format of the XML.
 * @property description Description of the configuration.
 * @property engineType Type of broker engine. Valid values are `ActiveMQ` and `RabbitMQ`.
 * @property engineVersion Version of the broker engine.
 * @property name Name of the configuration.
 * The following arguments are optional:
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ConfigurationArgs(
    public val authenticationStrategy: Output<String>? = null,
    public val `data`: Output<String>? = null,
    public val description: Output<String>? = null,
    public val engineType: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.mq.ConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.mq.ConfigurationArgs =
        com.pulumi.aws.mq.ConfigurationArgs.builder()
            .authenticationStrategy(authenticationStrategy?.applyValue({ args0 -> args0 }))
            .`data`(`data`?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .engineType(engineType?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConfigurationArgs].
 */
@PulumiTagMarker
public class ConfigurationArgsBuilder internal constructor() {
    private var authenticationStrategy: Output<String>? = null

    private var `data`: Output<String>? = null

    private var description: Output<String>? = null

    private var engineType: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Authentication strategy associated with the configuration. Valid values are `simple` and `ldap`. `ldap` is not supported for `engine_type` `RabbitMQ`.
     */
    @JvmName("otnqdcnyskhlqnfm")
    public suspend fun authenticationStrategy(`value`: Output<String>) {
        this.authenticationStrategy = value
    }

    /**
     * @param value Broker configuration in XML format for `ActiveMQ` or [Cuttlefish](https://github&#46;com/Kyorai/cuttlefish) format for `RabbitMQ`&#46; See [official docs](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/amazon-mq-broker-configuration-parameters.html) for supported parameters and format of the XML.
     */
    @JvmName("qydqmkmhsnrflavc")
    public suspend fun `data`(`value`: Output<String>) {
        this.`data` = value
    }

    /**
     * @param value Description of the configuration.
     */
    @JvmName("qcpcxvdctcixaljm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Type of broker engine. Valid values are `ActiveMQ` and `RabbitMQ`.
     */
    @JvmName("xtwrfgjxnuvdoucu")
    public suspend fun engineType(`value`: Output<String>) {
        this.engineType = value
    }

    /**
     * @param value Version of the broker engine.
     */
    @JvmName("jgvoyvkdbgmvwamb")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value Name of the configuration.
     * The following arguments are optional:
     */
    @JvmName("qcfnbituxclhftdq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uuacaubsbibmdwka")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Authentication strategy associated with the configuration. Valid values are `simple` and `ldap`. `ldap` is not supported for `engine_type` `RabbitMQ`.
     */
    @JvmName("bjbyqmskdobiswgf")
    public suspend fun authenticationStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationStrategy = mapped
    }

    /**
     * @param value Broker configuration in XML format for `ActiveMQ` or [Cuttlefish](https://github&#46;com/Kyorai/cuttlefish) format for `RabbitMQ`&#46; See [official docs](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/amazon-mq-broker-configuration-parameters.html) for supported parameters and format of the XML.
     */
    @JvmName("nxtibnnmmvduevre")
    public suspend fun `data`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`data` = mapped
    }

    /**
     * @param value Description of the configuration.
     */
    @JvmName("ietorulkkvrjtyxe")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Type of broker engine. Valid values are `ActiveMQ` and `RabbitMQ`.
     */
    @JvmName("mbjeviryysrxhvkw")
    public suspend fun engineType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineType = mapped
    }

    /**
     * @param value Version of the broker engine.
     */
    @JvmName("usrkvbdsfxdjpoun")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value Name of the configuration.
     * The following arguments are optional:
     */
    @JvmName("wycuqqkyochepmkw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mshqnqbhhikoylqs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("npqctkwolsscvtwp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConfigurationArgs = ConfigurationArgs(
        authenticationStrategy = authenticationStrategy,
        `data` = `data`,
        description = description,
        engineType = engineType,
        engineVersion = engineVersion,
        name = name,
        tags = tags,
    )
}
