@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin

import com.pulumi.aws.mq.MqFunctions.getBrokerEngineTypesPlain
import com.pulumi.aws.mq.MqFunctions.getBrokerPlain
import com.pulumi.aws.mq.MqFunctions.getInstanceTypeOfferingsPlain
import com.pulumi.aws.mq.kotlin.inputs.GetBrokerEngineTypesPlainArgs
import com.pulumi.aws.mq.kotlin.inputs.GetBrokerEngineTypesPlainArgsBuilder
import com.pulumi.aws.mq.kotlin.inputs.GetBrokerPlainArgs
import com.pulumi.aws.mq.kotlin.inputs.GetBrokerPlainArgsBuilder
import com.pulumi.aws.mq.kotlin.inputs.GetInstanceTypeOfferingsPlainArgs
import com.pulumi.aws.mq.kotlin.inputs.GetInstanceTypeOfferingsPlainArgsBuilder
import com.pulumi.aws.mq.kotlin.outputs.GetBrokerEngineTypesResult
import com.pulumi.aws.mq.kotlin.outputs.GetBrokerResult
import com.pulumi.aws.mq.kotlin.outputs.GetInstanceTypeOfferingsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.mq.kotlin.outputs.GetBrokerEngineTypesResult.Companion.toKotlin as getBrokerEngineTypesResultToKotlin
import com.pulumi.aws.mq.kotlin.outputs.GetBrokerResult.Companion.toKotlin as getBrokerResultToKotlin
import com.pulumi.aws.mq.kotlin.outputs.GetInstanceTypeOfferingsResult.Companion.toKotlin as getInstanceTypeOfferingsResultToKotlin

public object MqFunctions {
    /**
     * Provides information about a MQ Broker.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const brokerId = config.get("brokerId") || "";
     * const brokerName = config.get("brokerName") || "";
     * const byId = aws.mq.getBroker({
     *     brokerId: brokerId,
     * });
     * const byName = aws.mq.getBroker({
     *     brokerName: brokerName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * broker_id = config.get("brokerId")
     * if broker_id is None:
     *     broker_id = ""
     * broker_name = config.get("brokerName")
     * if broker_name is None:
     *     broker_name = ""
     * by_id = aws.mq.get_broker(broker_id=broker_id)
     * by_name = aws.mq.get_broker(broker_name=broker_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var brokerId = config.Get("brokerId") ?? "";
     *     var brokerName = config.Get("brokerName") ?? "";
     *     var byId = Aws.Mq.GetBroker.Invoke(new()
     *     {
     *         BrokerId = brokerId,
     *     });
     *     var byName = Aws.Mq.GetBroker.Invoke(new()
     *     {
     *         BrokerName = brokerName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mq"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		brokerId := ""
     * 		if param := cfg.Get("brokerId"); param != "" {
     * 			brokerId = param
     * 		}
     * 		brokerName := ""
     * 		if param := cfg.Get("brokerName"); param != "" {
     * 			brokerName = param
     * 		}
     * 		_, err := mq.LookupBroker(ctx, &mq.LookupBrokerArgs{
     * 			BrokerId: pulumi.StringRef(brokerId),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = mq.LookupBroker(ctx, &mq.LookupBrokerArgs{
     * 			BrokerName: pulumi.StringRef(brokerName),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.mq.MqFunctions;
     * import com.pulumi.aws.mq.inputs.GetBrokerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var brokerId = config.get("brokerId").orElse("");
     *         final var brokerName = config.get("brokerName").orElse("");
     *         final var byId = MqFunctions.getBroker(GetBrokerArgs.builder()
     *             .brokerId(brokerId)
     *             .build());
     *         final var byName = MqFunctions.getBroker(GetBrokerArgs.builder()
     *             .brokerName(brokerName)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   brokerId:
     *     type: string
     *     default:
     *   brokerName:
     *     type: string
     *     default:
     * variables:
     *   byId:
     *     fn::invoke:
     *       Function: aws:mq:getBroker
     *       Arguments:
     *         brokerId: ${brokerId}
     *   byName:
     *     fn::invoke:
     *       Function: aws:mq:getBroker
     *       Arguments:
     *         brokerName: ${brokerName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBroker.
     * @return A collection of values returned by getBroker.
     */
    public suspend fun getBroker(argument: GetBrokerPlainArgs): GetBrokerResult =
        getBrokerResultToKotlin(getBrokerPlain(argument.toJava()).await())

    /**
     * @see [getBroker].
     * @param brokerId Unique id of the mq broker.
     * @param brokerName Unique name of the mq broker.
     * @param tags
     * @return A collection of values returned by getBroker.
     */
    public suspend fun getBroker(
        brokerId: String? = null,
        brokerName: String? = null,
        tags: Map<String, String>? = null,
    ): GetBrokerResult {
        val argument = GetBrokerPlainArgs(
            brokerId = brokerId,
            brokerName = brokerName,
            tags = tags,
        )
        return getBrokerResultToKotlin(getBrokerPlain(argument.toJava()).await())
    }

    /**
     * @see [getBroker].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;mq&#46;kotlin&#46;inputs&#46;GetBrokerPlainArgs].
     * @return A collection of values returned by getBroker.
     */
    public suspend fun getBroker(argument: suspend GetBrokerPlainArgsBuilder.() -> Unit): GetBrokerResult {
        val builder = GetBrokerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBrokerResultToKotlin(getBrokerPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about available broker engines.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.mq.getBrokerEngineTypes({
     *     engineType: "ACTIVEMQ",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.mq.get_broker_engine_types(engine_type="ACTIVEMQ")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Mq.GetBrokerEngineTypes.Invoke(new()
     *     {
     *         EngineType = "ACTIVEMQ",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mq"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := mq.GetBrokerEngineTypes(ctx, &mq.GetBrokerEngineTypesArgs{
     * 			EngineType: pulumi.StringRef("ACTIVEMQ"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.mq.MqFunctions;
     * import com.pulumi.aws.mq.inputs.GetBrokerEngineTypesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MqFunctions.getBrokerEngineTypes(GetBrokerEngineTypesArgs.builder()
     *             .engineType("ACTIVEMQ")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:mq:getBrokerEngineTypes
     *       Arguments:
     *         engineType: ACTIVEMQ
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBrokerEngineTypes.
     * @return A collection of values returned by getBrokerEngineTypes.
     */
    public suspend fun getBrokerEngineTypes(argument: GetBrokerEngineTypesPlainArgs): GetBrokerEngineTypesResult =
        getBrokerEngineTypesResultToKotlin(getBrokerEngineTypesPlain(argument.toJava()).await())

    /**
     * @see [getBrokerEngineTypes].
     * @param engineType The MQ engine type to return version details for.
     * @return A collection of values returned by getBrokerEngineTypes.
     */
    public suspend fun getBrokerEngineTypes(engineType: String? = null): GetBrokerEngineTypesResult {
        val argument = GetBrokerEngineTypesPlainArgs(
            engineType = engineType,
        )
        return getBrokerEngineTypesResultToKotlin(getBrokerEngineTypesPlain(argument.toJava()).await())
    }

    /**
     * @see [getBrokerEngineTypes].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;mq&#46;kotlin&#46;inputs&#46;GetBrokerEngineTypesPlainArgs].
     * @return A collection of values returned by getBrokerEngineTypes.
     */
    public suspend fun getBrokerEngineTypes(argument: suspend GetBrokerEngineTypesPlainArgsBuilder.() -> Unit): GetBrokerEngineTypesResult {
        val builder = GetBrokerEngineTypesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBrokerEngineTypesResultToKotlin(getBrokerEngineTypesPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a MQ Broker Instance Offerings.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const empty = aws.mq.getInstanceTypeOfferings({});
     * const engine = aws.mq.getInstanceTypeOfferings({
     *     engineType: "ACTIVEMQ",
     * });
     * const storage = aws.mq.getInstanceTypeOfferings({
     *     storageType: "EBS",
     * });
     * const instance = aws.mq.getInstanceTypeOfferings({
     *     hostInstanceType: "mq.m5.large",
     * });
     * const all = aws.mq.getInstanceTypeOfferings({
     *     hostInstanceType: "mq.m5.large",
     *     storageType: "EBS",
     *     engineType: "ACTIVEMQ",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * empty = aws.mq.get_instance_type_offerings()
     * engine = aws.mq.get_instance_type_offerings(engine_type="ACTIVEMQ")
     * storage = aws.mq.get_instance_type_offerings(storage_type="EBS")
     * instance = aws.mq.get_instance_type_offerings(host_instance_type="mq.m5.large")
     * all = aws.mq.get_instance_type_offerings(host_instance_type="mq.m5.large",
     *     storage_type="EBS",
     *     engine_type="ACTIVEMQ")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var empty = Aws.Mq.GetInstanceTypeOfferings.Invoke();
     *     var engine = Aws.Mq.GetInstanceTypeOfferings.Invoke(new()
     *     {
     *         EngineType = "ACTIVEMQ",
     *     });
     *     var storage = Aws.Mq.GetInstanceTypeOfferings.Invoke(new()
     *     {
     *         StorageType = "EBS",
     *     });
     *     var instance = Aws.Mq.GetInstanceTypeOfferings.Invoke(new()
     *     {
     *         HostInstanceType = "mq.m5.large",
     *     });
     *     var all = Aws.Mq.GetInstanceTypeOfferings.Invoke(new()
     *     {
     *         HostInstanceType = "mq.m5.large",
     *         StorageType = "EBS",
     *         EngineType = "ACTIVEMQ",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mq"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := mq.GetInstanceTypeOfferings(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = mq.GetInstanceTypeOfferings(ctx, &mq.GetInstanceTypeOfferingsArgs{
     * 			EngineType: pulumi.StringRef("ACTIVEMQ"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = mq.GetInstanceTypeOfferings(ctx, &mq.GetInstanceTypeOfferingsArgs{
     * 			StorageType: pulumi.StringRef("EBS"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = mq.GetInstanceTypeOfferings(ctx, &mq.GetInstanceTypeOfferingsArgs{
     * 			HostInstanceType: pulumi.StringRef("mq.m5.large"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = mq.GetInstanceTypeOfferings(ctx, &mq.GetInstanceTypeOfferingsArgs{
     * 			HostInstanceType: pulumi.StringRef("mq.m5.large"),
     * 			StorageType:      pulumi.StringRef("EBS"),
     * 			EngineType:       pulumi.StringRef("ACTIVEMQ"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.mq.MqFunctions;
     * import com.pulumi.aws.mq.inputs.GetInstanceTypeOfferingsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var empty = MqFunctions.getInstanceTypeOfferings();
     *         final var engine = MqFunctions.getInstanceTypeOfferings(GetInstanceTypeOfferingsArgs.builder()
     *             .engineType("ACTIVEMQ")
     *             .build());
     *         final var storage = MqFunctions.getInstanceTypeOfferings(GetInstanceTypeOfferingsArgs.builder()
     *             .storageType("EBS")
     *             .build());
     *         final var instance = MqFunctions.getInstanceTypeOfferings(GetInstanceTypeOfferingsArgs.builder()
     *             .hostInstanceType("mq.m5.large")
     *             .build());
     *         final var all = MqFunctions.getInstanceTypeOfferings(GetInstanceTypeOfferingsArgs.builder()
     *             .hostInstanceType("mq.m5.large")
     *             .storageType("EBS")
     *             .engineType("ACTIVEMQ")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   empty:
     *     fn::invoke:
     *       Function: aws:mq:getInstanceTypeOfferings
     *       Arguments: {}
     *   engine:
     *     fn::invoke:
     *       Function: aws:mq:getInstanceTypeOfferings
     *       Arguments:
     *         engineType: ACTIVEMQ
     *   storage:
     *     fn::invoke:
     *       Function: aws:mq:getInstanceTypeOfferings
     *       Arguments:
     *         storageType: EBS
     *   instance:
     *     fn::invoke:
     *       Function: aws:mq:getInstanceTypeOfferings
     *       Arguments:
     *         hostInstanceType: mq.m5.large
     *   all:
     *     fn::invoke:
     *       Function: aws:mq:getInstanceTypeOfferings
     *       Arguments:
     *         hostInstanceType: mq.m5.large
     *         storageType: EBS
     *         engineType: ACTIVEMQ
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceTypeOfferings.
     * @return A collection of values returned by getInstanceTypeOfferings.
     */
    public suspend fun getInstanceTypeOfferings(argument: GetInstanceTypeOfferingsPlainArgs): GetInstanceTypeOfferingsResult =
        getInstanceTypeOfferingsResultToKotlin(getInstanceTypeOfferingsPlain(argument.toJava()).await())

    /**
     * @see [getInstanceTypeOfferings].
     * @param engineType Filter response by engine type.
     * @param hostInstanceType Filter response by host instance type.
     * @param storageType Filter response by storage type.
     * @return A collection of values returned by getInstanceTypeOfferings.
     */
    public suspend fun getInstanceTypeOfferings(
        engineType: String? = null,
        hostInstanceType: String? = null,
        storageType: String? = null,
    ): GetInstanceTypeOfferingsResult {
        val argument = GetInstanceTypeOfferingsPlainArgs(
            engineType = engineType,
            hostInstanceType = hostInstanceType,
            storageType = storageType,
        )
        return getInstanceTypeOfferingsResultToKotlin(getInstanceTypeOfferingsPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceTypeOfferings].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;mq&#46;kotlin&#46;inputs&#46;GetInstanceTypeOfferingsPlainArgs].
     * @return A collection of values returned by getInstanceTypeOfferings.
     */
    public suspend fun getInstanceTypeOfferings(argument: suspend GetInstanceTypeOfferingsPlainArgsBuilder.() -> Unit): GetInstanceTypeOfferingsResult {
        val builder = GetInstanceTypeOfferingsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceTypeOfferingsResultToKotlin(getInstanceTypeOfferingsPlain(builtArgument.toJava()).await())
    }
}
