@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.inputs

import com.pulumi.aws.mq.inputs.BrokerEncryptionOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyId Amazon Resource Name (ARN) of Key Management Service (KMS) Customer Master Key (CMK) to use for encryption at rest. Requires setting `use_aws_owned_key` to `false`. To perform drift detection when AWS-managed CMKs or customer-managed CMKs are in use, this value must be configured.
 * @property useAwsOwnedKey Whether to enable an AWS-owned KMS CMK that is not in your account. Defaults to `true`. Setting to `false` without configuring `kms_key_id` will create an AWS-managed CMK aliased to `aws/mq` in your account.
 */
public data class BrokerEncryptionOptionsArgs(
    public val kmsKeyId: Output<String>? = null,
    public val useAwsOwnedKey: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.mq.inputs.BrokerEncryptionOptionsArgs> {
    override fun toJava(): com.pulumi.aws.mq.inputs.BrokerEncryptionOptionsArgs =
        com.pulumi.aws.mq.inputs.BrokerEncryptionOptionsArgs.builder()
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .useAwsOwnedKey(useAwsOwnedKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BrokerEncryptionOptionsArgs].
 */
@PulumiTagMarker
public class BrokerEncryptionOptionsArgsBuilder internal constructor() {
    private var kmsKeyId: Output<String>? = null

    private var useAwsOwnedKey: Output<Boolean>? = null

    /**
     * @param value Amazon Resource Name (ARN) of Key Management Service (KMS) Customer Master Key (CMK) to use for encryption at rest. Requires setting `use_aws_owned_key` to `false`. To perform drift detection when AWS-managed CMKs or customer-managed CMKs are in use, this value must be configured.
     */
    @JvmName("diirxixtatktwrmf")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Whether to enable an AWS-owned KMS CMK that is not in your account. Defaults to `true`. Setting to `false` without configuring `kms_key_id` will create an AWS-managed CMK aliased to `aws/mq` in your account.
     */
    @JvmName("qbamiwrufnmhctux")
    public suspend fun useAwsOwnedKey(`value`: Output<Boolean>) {
        this.useAwsOwnedKey = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of Key Management Service (KMS) Customer Master Key (CMK) to use for encryption at rest. Requires setting `use_aws_owned_key` to `false`. To perform drift detection when AWS-managed CMKs or customer-managed CMKs are in use, this value must be configured.
     */
    @JvmName("lrrcothxbbqomkgf")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Whether to enable an AWS-owned KMS CMK that is not in your account. Defaults to `true`. Setting to `false` without configuring `kms_key_id` will create an AWS-managed CMK aliased to `aws/mq` in your account.
     */
    @JvmName("wntijernssqqbvkv")
    public suspend fun useAwsOwnedKey(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useAwsOwnedKey = mapped
    }

    internal fun build(): BrokerEncryptionOptionsArgs = BrokerEncryptionOptionsArgs(
        kmsKeyId = kmsKeyId,
        useAwsOwnedKey = useAwsOwnedKey,
    )
}
