@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.inputs

import com.pulumi.aws.mq.inputs.BrokerLogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property audit Enables audit logging. Auditing is only possible for `engine_type` of `ActiveMQ`. User management action made using JMX or the ActiveMQ Web Console is logged. Defaults to `false`.
 * @property general Enables general logging via CloudWatch. Defaults to `false`.
 */
public data class BrokerLogsArgs(
    public val audit: Output<Boolean>? = null,
    public val general: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.mq.inputs.BrokerLogsArgs> {
    override fun toJava(): com.pulumi.aws.mq.inputs.BrokerLogsArgs =
        com.pulumi.aws.mq.inputs.BrokerLogsArgs.builder()
            .audit(audit?.applyValue({ args0 -> args0 }))
            .general(general?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BrokerLogsArgs].
 */
@PulumiTagMarker
public class BrokerLogsArgsBuilder internal constructor() {
    private var audit: Output<Boolean>? = null

    private var general: Output<Boolean>? = null

    /**
     * @param value Enables audit logging. Auditing is only possible for `engine_type` of `ActiveMQ`. User management action made using JMX or the ActiveMQ Web Console is logged. Defaults to `false`.
     */
    @JvmName("tnqrslyijculyjqf")
    public suspend fun audit(`value`: Output<Boolean>) {
        this.audit = value
    }

    /**
     * @param value Enables general logging via CloudWatch. Defaults to `false`.
     */
    @JvmName("kgktrvbdtgoflkrs")
    public suspend fun general(`value`: Output<Boolean>) {
        this.general = value
    }

    /**
     * @param value Enables audit logging. Auditing is only possible for `engine_type` of `ActiveMQ`. User management action made using JMX or the ActiveMQ Web Console is logged. Defaults to `false`.
     */
    @JvmName("jtbxsjilgfxyevdn")
    public suspend fun audit(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audit = mapped
    }

    /**
     * @param value Enables general logging via CloudWatch. Defaults to `false`.
     */
    @JvmName("nutjsgedymfcxrfd")
    public suspend fun general(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.general = mapped
    }

    internal fun build(): BrokerLogsArgs = BrokerLogsArgs(
        audit = audit,
        general = general,
    )
}
