@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.inputs

import com.pulumi.aws.mq.inputs.BrokerUserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property consoleAccess Whether to enable access to the [ActiveMQ Web Console](http://activemq.apache.org/web-console.html) for the user. Applies to `engine_type` of `ActiveMQ` only.
 * @property groups List of groups (20 maximum) to which the ActiveMQ user belongs. Applies to `engine_type` of `ActiveMQ` only.
 * @property password Password of the user. It must be 12 to 250 characters long, at least 4 unique characters, and must not contain commas.
 * @property replicationUser Whether to set set replication user. Defaults to `false`.
 * @property username Username of the user.
 * > **NOTE:** AWS currently does not support updating RabbitMQ users. Updates to users can only be in the RabbitMQ UI.
 */
public data class BrokerUserArgs(
    public val consoleAccess: Output<Boolean>? = null,
    public val groups: Output<List<String>>? = null,
    public val password: Output<String>,
    public val replicationUser: Output<Boolean>? = null,
    public val username: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.mq.inputs.BrokerUserArgs> {
    override fun toJava(): com.pulumi.aws.mq.inputs.BrokerUserArgs =
        com.pulumi.aws.mq.inputs.BrokerUserArgs.builder()
            .consoleAccess(consoleAccess?.applyValue({ args0 -> args0 }))
            .groups(groups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .password(password.applyValue({ args0 -> args0 }))
            .replicationUser(replicationUser?.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BrokerUserArgs].
 */
@PulumiTagMarker
public class BrokerUserArgsBuilder internal constructor() {
    private var consoleAccess: Output<Boolean>? = null

    private var groups: Output<List<String>>? = null

    private var password: Output<String>? = null

    private var replicationUser: Output<Boolean>? = null

    private var username: Output<String>? = null

    /**
     * @param value Whether to enable access to the [ActiveMQ Web Console](http://activemq.apache.org/web-console.html) for the user. Applies to `engine_type` of `ActiveMQ` only.
     */
    @JvmName("ymdlwuqedhsuwoce")
    public suspend fun consoleAccess(`value`: Output<Boolean>) {
        this.consoleAccess = value
    }

    /**
     * @param value List of groups (20 maximum) to which the ActiveMQ user belongs. Applies to `engine_type` of `ActiveMQ` only.
     */
    @JvmName("sfqwkqnixmgdohmm")
    public suspend fun groups(`value`: Output<List<String>>) {
        this.groups = value
    }

    @JvmName("bssmlxnrrskntjox")
    public suspend fun groups(vararg values: Output<String>) {
        this.groups = Output.all(values.asList())
    }

    /**
     * @param values List of groups (20 maximum) to which the ActiveMQ user belongs. Applies to `engine_type` of `ActiveMQ` only.
     */
    @JvmName("eqcbeklvoqafnxxk")
    public suspend fun groups(values: List<Output<String>>) {
        this.groups = Output.all(values)
    }

    /**
     * @param value Password of the user. It must be 12 to 250 characters long, at least 4 unique characters, and must not contain commas.
     */
    @JvmName("grqfautraenwqnnb")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Whether to set set replication user. Defaults to `false`.
     */
    @JvmName("wvmjnivdqnjcqctg")
    public suspend fun replicationUser(`value`: Output<Boolean>) {
        this.replicationUser = value
    }

    /**
     * @param value Username of the user.
     * > **NOTE:** AWS currently does not support updating RabbitMQ users. Updates to users can only be in the RabbitMQ UI.
     */
    @JvmName("wumodqfufgaunjqt")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Whether to enable access to the [ActiveMQ Web Console](http://activemq.apache.org/web-console.html) for the user. Applies to `engine_type` of `ActiveMQ` only.
     */
    @JvmName("obkhjjkmoylxadio")
    public suspend fun consoleAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consoleAccess = mapped
    }

    /**
     * @param value List of groups (20 maximum) to which the ActiveMQ user belongs. Applies to `engine_type` of `ActiveMQ` only.
     */
    @JvmName("qfhbgdkxobhspdgs")
    public suspend fun groups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param values List of groups (20 maximum) to which the ActiveMQ user belongs. Applies to `engine_type` of `ActiveMQ` only.
     */
    @JvmName("sqhrpdeowarcaurb")
    public suspend fun groups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param value Password of the user. It must be 12 to 250 characters long, at least 4 unique characters, and must not contain commas.
     */
    @JvmName("ylefqpouwxjdgact")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Whether to set set replication user. Defaults to `false`.
     */
    @JvmName("bnvwjmkfteiphevg")
    public suspend fun replicationUser(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationUser = mapped
    }

    /**
     * @param value Username of the user.
     * > **NOTE:** AWS currently does not support updating RabbitMQ users. Updates to users can only be in the RabbitMQ UI.
     */
    @JvmName("yjovvaxwvflacggd")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): BrokerUserArgs = BrokerUserArgs(
        consoleAccess = consoleAccess,
        groups = groups,
        password = password ?: throw PulumiNullFieldException("password"),
        replicationUser = replicationUser,
        username = username ?: throw PulumiNullFieldException("username"),
    )
}
