@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.inputs

import com.pulumi.aws.mq.inputs.GetBrokerEngineTypesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBrokerEngineTypes.
 * @property engineType The MQ engine type to return version details for.
 */
public data class GetBrokerEngineTypesPlainArgs(
    public val engineType: String? = null,
) : ConvertibleToJava<com.pulumi.aws.mq.inputs.GetBrokerEngineTypesPlainArgs> {
    override fun toJava(): com.pulumi.aws.mq.inputs.GetBrokerEngineTypesPlainArgs =
        com.pulumi.aws.mq.inputs.GetBrokerEngineTypesPlainArgs.builder()
            .engineType(engineType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBrokerEngineTypesPlainArgs].
 */
@PulumiTagMarker
public class GetBrokerEngineTypesPlainArgsBuilder internal constructor() {
    private var engineType: String? = null

    /**
     * @param value The MQ engine type to return version details for.
     */
    @JvmName("rsoalmbkmrcmwerq")
    public suspend fun engineType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engineType = mapped
    }

    internal fun build(): GetBrokerEngineTypesPlainArgs = GetBrokerEngineTypesPlainArgs(
        engineType = engineType,
    )
}
