@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property consoleUrl The URL of the [ActiveMQ Web Console](http://activemq&#46;apache&#46;org/web-console&#46;html) or the [RabbitMQ Management UI](https://www.rabbitmq.com/management.html#external-monitoring) depending on `engine_type`.
 * @property endpoints Broker's wire-level protocol endpoints in the following order & format referenceable e.g., as `instances.0.endpoints.0` (SSL):
 * * For `ActiveMQ`:
 * * `ssl://broker-id.mq.us-west-2.amazonaws.com:61617`
 * * `amqp+ssl://broker-id.mq.us-west-2.amazonaws.com:5671`
 * * `stomp+ssl://broker-id.mq.us-west-2.amazonaws.com:61614`
 * * `mqtt+ssl://broker-id.mq.us-west-2.amazonaws.com:8883`
 * * `wss://broker-id.mq.us-west-2.amazonaws.com:61619`
 * * For `RabbitMQ`:
 * * `amqps://broker-id.mq.us-west-2.amazonaws.com:5671`
 * @property ipAddress IP Address of the broker.
 */
public data class BrokerInstance(
    public val consoleUrl: String? = null,
    public val endpoints: List<String>? = null,
    public val ipAddress: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mq.outputs.BrokerInstance): BrokerInstance =
            BrokerInstance(
                consoleUrl = javaType.consoleUrl().map({ args0 -> args0 }).orElse(null),
                endpoints = javaType.endpoints().map({ args0 -> args0 }),
                ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            )
    }
}
