@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property hosts List of a fully qualified domain name of the LDAP server and an optional failover server.
 * @property roleBase Fully qualified name of the directory to search for a user’s groups.
 * @property roleName Specifies the LDAP attribute that identifies the group name attribute in the object returned from the group membership query.
 * @property roleSearchMatching Search criteria for groups.
 * @property roleSearchSubtree Whether the directory search scope is the entire sub-tree.
 * @property serviceAccountPassword Service account password.
 * @property serviceAccountUsername Service account username.
 * @property userBase Fully qualified name of the directory where you want to search for users.
 * @property userRoleName Specifies the name of the LDAP attribute for the user group membership.
 * @property userSearchMatching Search criteria for users.
 * @property userSearchSubtree Whether the directory search scope is the entire sub-tree.
 */
public data class BrokerLdapServerMetadata(
    public val hosts: List<String>? = null,
    public val roleBase: String? = null,
    public val roleName: String? = null,
    public val roleSearchMatching: String? = null,
    public val roleSearchSubtree: Boolean? = null,
    public val serviceAccountPassword: String? = null,
    public val serviceAccountUsername: String? = null,
    public val userBase: String? = null,
    public val userRoleName: String? = null,
    public val userSearchMatching: String? = null,
    public val userSearchSubtree: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mq.outputs.BrokerLdapServerMetadata): BrokerLdapServerMetadata = BrokerLdapServerMetadata(
            hosts = javaType.hosts().map({ args0 -> args0 }),
            roleBase = javaType.roleBase().map({ args0 -> args0 }).orElse(null),
            roleName = javaType.roleName().map({ args0 -> args0 }).orElse(null),
            roleSearchMatching = javaType.roleSearchMatching().map({ args0 -> args0 }).orElse(null),
            roleSearchSubtree = javaType.roleSearchSubtree().map({ args0 -> args0 }).orElse(null),
            serviceAccountPassword = javaType.serviceAccountPassword().map({ args0 -> args0 }).orElse(null),
            serviceAccountUsername = javaType.serviceAccountUsername().map({ args0 -> args0 }).orElse(null),
            userBase = javaType.userBase().map({ args0 -> args0 }).orElse(null),
            userRoleName = javaType.userRoleName().map({ args0 -> args0 }).orElse(null),
            userSearchMatching = javaType.userSearchMatching().map({ args0 -> args0 }).orElse(null),
            userSearchSubtree = javaType.userSearchSubtree().map({ args0 -> args0 }).orElse(null),
        )
    }
}
