@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property audit Enables audit logging. Auditing is only possible for `engine_type` of `ActiveMQ`. User management action made using JMX or the ActiveMQ Web Console is logged. Defaults to `false`.
 * @property general Enables general logging via CloudWatch. Defaults to `false`.
 */
public data class BrokerLogs(
    public val audit: Boolean? = null,
    public val general: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mq.outputs.BrokerLogs): BrokerLogs = BrokerLogs(
            audit = javaType.audit().map({ args0 -> args0 }).orElse(null),
            general = javaType.general().map({ args0 -> args0 }).orElse(null),
        )
    }
}
