@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dayOfWeek Day of the week, e.g., `MONDAY`, `TUESDAY`, or `WEDNESDAY`.
 * @property timeOfDay Time, in 24-hour format, e.g., `02:00`.
 * @property timeZone Time zone in either the Country/City format or the UTC offset format, e.g., `CET`.
 */
public data class BrokerMaintenanceWindowStartTime(
    public val dayOfWeek: String,
    public val timeOfDay: String,
    public val timeZone: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mq.outputs.BrokerMaintenanceWindowStartTime): BrokerMaintenanceWindowStartTime = BrokerMaintenanceWindowStartTime(
            dayOfWeek = javaType.dayOfWeek(),
            timeOfDay = javaType.timeOfDay(),
            timeZone = javaType.timeZone(),
        )
    }
}
