@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property consoleAccess Whether to enable access to the [ActiveMQ Web Console](http://activemq.apache.org/web-console.html) for the user. Applies to `engine_type` of `ActiveMQ` only.
 * @property groups List of groups (20 maximum) to which the ActiveMQ user belongs. Applies to `engine_type` of `ActiveMQ` only.
 * @property password Password of the user. It must be 12 to 250 characters long, at least 4 unique characters, and must not contain commas.
 * @property replicationUser Whether to set set replication user. Defaults to `false`.
 * @property username Username of the user.
 * > **NOTE:** AWS currently does not support updating RabbitMQ users. Updates to users can only be in the RabbitMQ UI.
 */
public data class BrokerUser(
    public val consoleAccess: Boolean? = null,
    public val groups: List<String>? = null,
    public val password: String,
    public val replicationUser: Boolean? = null,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mq.outputs.BrokerUser): BrokerUser = BrokerUser(
            consoleAccess = javaType.consoleAccess().map({ args0 -> args0 }).orElse(null),
            groups = javaType.groups().map({ args0 -> args0 }),
            password = javaType.password(),
            replicationUser = javaType.replicationUser().map({ args0 -> args0 }).orElse(null),
            username = javaType.username(),
        )
    }
}
