@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property engineType The MQ engine type to return version details for.
 * @property engineVersions The list of engine versions.
 */
public data class GetBrokerEngineTypesBrokerEngineType(
    public val engineType: String,
    public val engineVersions: List<GetBrokerEngineTypesBrokerEngineTypeEngineVersion>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mq.outputs.GetBrokerEngineTypesBrokerEngineType): GetBrokerEngineTypesBrokerEngineType = GetBrokerEngineTypesBrokerEngineType(
            engineType = javaType.engineType(),
            engineVersions = javaType.engineVersions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.mq.kotlin.outputs.GetBrokerEngineTypesBrokerEngineTypeEngineVersion.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
