@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBrokerEngineTypes.
 * @property brokerEngineTypes A list of available engine types and versions. See Engine Types.
 * @property engineType The broker's engine type.
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetBrokerEngineTypesResult(
    public val brokerEngineTypes: List<GetBrokerEngineTypesBrokerEngineType>,
    public val engineType: String? = null,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mq.outputs.GetBrokerEngineTypesResult): GetBrokerEngineTypesResult = GetBrokerEngineTypesResult(
            brokerEngineTypes = javaType.brokerEngineTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.mq.kotlin.outputs.GetBrokerEngineTypesBrokerEngineType.Companion.toKotlin(args0)
                })
            }),
            engineType = javaType.engineType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
        )
    }
}
