@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getBroker.
 * @property arn
 * @property authenticationStrategy
 * @property autoMinorVersionUpgrade
 * @property brokerId
 * @property brokerName
 * @property configuration
 * @property deploymentMode
 * @property encryptionOptions
 * @property engineType
 * @property engineVersion
 * @property hostInstanceType
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instances
 * @property ldapServerMetadatas
 * @property logs
 * @property maintenanceWindowStartTime
 * @property publiclyAccessible
 * @property securityGroups
 * @property storageType
 * @property subnetIds
 * @property tags
 * @property users
 */
public data class GetBrokerResult(
    public val arn: String,
    public val authenticationStrategy: String,
    public val autoMinorVersionUpgrade: Boolean,
    public val brokerId: String,
    public val brokerName: String,
    public val configuration: GetBrokerConfiguration,
    public val deploymentMode: String,
    public val encryptionOptions: List<GetBrokerEncryptionOption>,
    public val engineType: String,
    public val engineVersion: String,
    public val hostInstanceType: String,
    public val id: String,
    public val instances: List<GetBrokerInstance>,
    public val ldapServerMetadatas: List<GetBrokerLdapServerMetadata>,
    public val logs: GetBrokerLogs,
    public val maintenanceWindowStartTime: GetBrokerMaintenanceWindowStartTime,
    public val publiclyAccessible: Boolean,
    public val securityGroups: List<String>,
    public val storageType: String,
    public val subnetIds: List<String>,
    public val tags: Map<String, String>,
    public val users: List<GetBrokerUser>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mq.outputs.GetBrokerResult): GetBrokerResult =
            GetBrokerResult(
                arn = javaType.arn(),
                authenticationStrategy = javaType.authenticationStrategy(),
                autoMinorVersionUpgrade = javaType.autoMinorVersionUpgrade(),
                brokerId = javaType.brokerId(),
                brokerName = javaType.brokerName(),
                configuration = javaType.configuration().let({ args0 ->
                    com.pulumi.aws.mq.kotlin.outputs.GetBrokerConfiguration.Companion.toKotlin(args0)
                }),
                deploymentMode = javaType.deploymentMode(),
                encryptionOptions = javaType.encryptionOptions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.mq.kotlin.outputs.GetBrokerEncryptionOption.Companion.toKotlin(args0)
                    })
                }),
                engineType = javaType.engineType(),
                engineVersion = javaType.engineVersion(),
                hostInstanceType = javaType.hostInstanceType(),
                id = javaType.id(),
                instances = javaType.instances().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.mq.kotlin.outputs.GetBrokerInstance.Companion.toKotlin(args0)
                    })
                }),
                ldapServerMetadatas = javaType.ldapServerMetadatas().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.mq.kotlin.outputs.GetBrokerLdapServerMetadata.Companion.toKotlin(args0)
                    })
                }),
                logs = javaType.logs().let({ args0 ->
                    com.pulumi.aws.mq.kotlin.outputs.GetBrokerLogs.Companion.toKotlin(args0)
                }),
                maintenanceWindowStartTime = javaType.maintenanceWindowStartTime().let({ args0 ->
                    com.pulumi.aws.mq.kotlin.outputs.GetBrokerMaintenanceWindowStartTime.Companion.toKotlin(args0)
                }),
                publiclyAccessible = javaType.publiclyAccessible(),
                securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
                storageType = javaType.storageType(),
                subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                users = javaType.users().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.mq.kotlin.outputs.GetBrokerUser.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
