@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZones List of available AZs. See Availability Zones. below
 * @property engineType Filter response by engine type.
 * @property hostInstanceType Filter response by host instance type.
 * @property storageType Filter response by storage type.
 * @property supportedDeploymentModes The list of supported deployment modes.
 * @property supportedEngineVersions The list of supported engine versions.
 */
public data class GetInstanceTypeOfferingsBrokerInstanceOption(
    public val availabilityZones: List<GetInstanceTypeOfferingsBrokerInstanceOptionAvailabilityZone>,
    public val engineType: String,
    public val hostInstanceType: String,
    public val storageType: String,
    public val supportedDeploymentModes: List<String>,
    public val supportedEngineVersions: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mq.outputs.GetInstanceTypeOfferingsBrokerInstanceOption): GetInstanceTypeOfferingsBrokerInstanceOption = GetInstanceTypeOfferingsBrokerInstanceOption(
            availabilityZones = javaType.availabilityZones().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.mq.kotlin.outputs.GetInstanceTypeOfferingsBrokerInstanceOptionAvailabilityZone.Companion.toKotlin(args0)
                })
            }),
            engineType = javaType.engineType(),
            hostInstanceType = javaType.hostInstanceType(),
            storageType = javaType.storageType(),
            supportedDeploymentModes = javaType.supportedDeploymentModes().map({ args0 -> args0 }),
            supportedEngineVersions = javaType.supportedEngineVersions().map({ args0 -> args0 }),
        )
    }
}
