@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.aws.msk.ClusterPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Managed Streaming for Kafka Cluster Policy.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const currentGetPartition = aws.getPartition({});
 * const example = new aws.msk.ClusterPolicy("example", {
 *     clusterArn: exampleAwsMskCluster.arn,
 *     policy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Sid: "ExampleMskClusterPolicy",
 *             Effect: "Allow",
 *             Principal: {
 *                 AWS: Promise.all([currentGetPartition, current])&#46;then(([currentGetPartition, current]) => `arn:${currentGetPartition.partition}:iam::${current.accountId}:root`),
 *             },
 *             Action: [
 *                 "kafka:Describe*",
 *                 "kafka:Get*",
 *                 "kafka:CreateVpcConnection",
 *                 "kafka:GetBootstrapBrokers",
 *             ],
 *             Resource: exampleAwsMskCluster.arn,
 *         }],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * current_get_partition = aws.get_partition()
 * example = aws.msk.ClusterPolicy("example",
 *     cluster_arn=example_aws_msk_cluster["arn"],
 *     policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Sid": "ExampleMskClusterPolicy",
 *             "Effect": "Allow",
 *             "Principal": {
 *                 "AWS": f"arn:{current_get_partition.partition}:iam::{current.account_id}:root",
 *             },
 *             "Action": [
 *                 "kafka:Describe*",
 *                 "kafka:Get*",
 *                 "kafka:CreateVpcConnection",
 *                 "kafka:GetBootstrapBrokers",
 *             ],
 *             "Resource": example_aws_msk_cluster["arn"],
 *         }],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var currentGetPartition = Aws.GetPartition.Invoke();
 *     var example = new Aws.Msk.ClusterPolicy("example", new()
 *     {
 *         ClusterArn = exampleAwsMskCluster.Arn,
 *         Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Sid"] = "ExampleMskClusterPolicy",
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["AWS"] = Output.Tuple(currentGetPartition, current).Apply(values =>
 *                         {
 *                             var currentGetPartition = values.Item1;
 *                             var current = values.Item2;
 *                             return $"arn:{currentGetPartition.Apply(getPartitionResult => getPartitionResult.Partition)}:iam::{current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId)}:root";
 *                         }),
 *                     },
 *                     ["Action"] = new[]
 *                     {
 *                         "kafka:Describe*",
 *                         "kafka:Get*",
 *                         "kafka:CreateVpcConnection",
 *                         "kafka:GetBootstrapBrokers",
 *                     },
 *                     ["Resource"] = exampleAwsMskCluster.Arn,
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/msk"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		currentGetPartition, err := aws.GetPartition(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Sid":    "ExampleMskClusterPolicy",
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"AWS": fmt.Sprintf("arn:%v:iam::%v:root", currentGetPartition.Partition, current.AccountId),
 * 					},
 * 					"Action": []string{
 * 						"kafka:Describe*",
 * 						"kafka:Get*",
 * 						"kafka:CreateVpcConnection",
 * 						"kafka:GetBootstrapBrokers",
 * 					},
 * 					"Resource": exampleAwsMskCluster.Arn,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = msk.NewClusterPolicy(ctx, "example", &msk.ClusterPolicyArgs{
 * 			ClusterArn: pulumi.Any(exampleAwsMskCluster.Arn),
 * 			Policy:     pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.msk.ClusterPolicy;
 * import com.pulumi.aws.msk.ClusterPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var currentGetPartition = AwsFunctions.getPartition();
 *         var example = new ClusterPolicy("example", ClusterPolicyArgs.builder()
 *             .clusterArn(exampleAwsMskCluster.arn())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Sid", "ExampleMskClusterPolicy"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", String.format("arn:%s:iam::%s:root", currentGetPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                         )),
 *                         jsonProperty("Action", jsonArray(
 *                             "kafka:Describe*",
 *                             "kafka:Get*",
 *                             "kafka:CreateVpcConnection",
 *                             "kafka:GetBootstrapBrokers"
 *                         )),
 *                         jsonProperty("Resource", exampleAwsMskCluster.arn())
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:msk:ClusterPolicy
 *     properties:
 *       clusterArn: ${exampleAwsMskCluster.arn}
 *       policy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Sid: ExampleMskClusterPolicy
 *               Effect: Allow
 *               Principal:
 *                 AWS: arn:${currentGetPartition.partition}:iam::${current.accountId}:root
 *               Action:
 *                 - kafka:Describe*
 *                 - kafka:Get*
 *                 - kafka:CreateVpcConnection
 *                 - kafka:GetBootstrapBrokers
 *               Resource: ${exampleAwsMskCluster.arn}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   currentGetPartition:
 *     fn::invoke:
 *       Function: aws:getPartition
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Managed Streaming for Kafka Cluster Policy using the `cluster_arn`. For example:
 * ```sh
 * $ pulumi import aws:msk/clusterPolicy:ClusterPolicy example arn:aws:kafka:us-west-2:123456789012:cluster/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
 * ```
 * @property clusterArn The Amazon Resource Name (ARN) that uniquely identifies the cluster.
 * @property policy Resource policy for cluster.
 */
public data class ClusterPolicyArgs(
    public val clusterArn: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.ClusterPolicyArgs> {
    override fun toJava(): com.pulumi.aws.msk.ClusterPolicyArgs =
        com.pulumi.aws.msk.ClusterPolicyArgs.builder()
            .clusterArn(clusterArn?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterPolicyArgs].
 */
@PulumiTagMarker
public class ClusterPolicyArgsBuilder internal constructor() {
    private var clusterArn: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     */
    @JvmName("svnlheuvmtebjovs")
    public suspend fun clusterArn(`value`: Output<String>) {
        this.clusterArn = value
    }

    /**
     * @param value Resource policy for cluster.
     */
    @JvmName("unpxbiohdmyvtiuo")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     */
    @JvmName("swfisdjerxvvwell")
    public suspend fun clusterArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterArn = mapped
    }

    /**
     * @param value Resource policy for cluster.
     */
    @JvmName("xcwiwbqkqbvmpmxp")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): ClusterPolicyArgs = ClusterPolicyArgs(
        clusterArn = clusterArn,
        policy = policy,
    )
}
