@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.aws.msk.ConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages an Amazon Managed Streaming for Kafka configuration. More information can be found on the [MSK Developer Guide](https://docs.aws.amazon.com/msk/latest/developerguide/msk-configuration.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.msk.Configuration("example", {
 *     kafkaVersions: ["2&#46;1&#46;0"],
 *     name: "example",
 *     serverProperties: `auto.create.topics.enable = true
 * delete.topic.enable = true
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.msk.Configuration("example",
 *     kafka_versions=["2&#46;1&#46;0"],
 *     name="example",
 *     server_properties="""auto.create.topics.enable = true
 * delete.topic.enable = true
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Msk.Configuration("example", new()
 *     {
 *         KafkaVersions = new[]
 *         {
 *             "2.1.0",
 *         },
 *         Name = "example",
 *         ServerProperties = @"auto.create.topics.enable = true
 * delete.topic.enable = true
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/msk"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := msk.NewConfiguration(ctx, "example", &msk.ConfigurationArgs{
 * 			KafkaVersions: pulumi.StringArray{
 * 				pulumi.String("2.1.0"),
 * 			},
 * 			Name:             pulumi.String("example"),
 * 			ServerProperties: pulumi.String("auto.create.topics.enable = true\ndelete.topic.enable = true\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.msk.Configuration;
 * import com.pulumi.aws.msk.ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Configuration("example", ConfigurationArgs.builder()
 *             .kafkaVersions("2.1.0")
 *             .name("example")
 *             .serverProperties("""
 * auto.create.topics.enable = true
 * delete.topic.enable = true
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:msk:Configuration
 *     properties:
 *       kafkaVersions:
 *         - 2.1.0
 *       name: example
 *       serverProperties: |
 *         auto.create.topics.enable = true
 *         delete.topic.enable = true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MSK configurations using the configuration ARN. For example:
 * ```sh
 * $ pulumi import aws:msk/configuration:Configuration example arn:aws:kafka:us-west-2:123456789012:configuration/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
 * ```
 * @property description Description of the configuration.
 * @property kafkaVersions List of Apache Kafka versions which can use this configuration.
 * @property name Name of the configuration.
 * @property serverProperties Contents of the server.properties file. Supported properties are documented in the [MSK Developer Guide](https://docs.aws.amazon.com/msk/latest/developerguide/msk-configuration-properties.html).
 */
public data class ConfigurationArgs(
    public val description: Output<String>? = null,
    public val kafkaVersions: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val serverProperties: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.ConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.msk.ConfigurationArgs =
        com.pulumi.aws.msk.ConfigurationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .kafkaVersions(kafkaVersions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .serverProperties(serverProperties?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationArgs].
 */
@PulumiTagMarker
public class ConfigurationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var kafkaVersions: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var serverProperties: Output<String>? = null

    /**
     * @param value Description of the configuration.
     */
    @JvmName("wegprgiheuyayiix")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of Apache Kafka versions which can use this configuration.
     */
    @JvmName("xssfkeugvvwlnnjj")
    public suspend fun kafkaVersions(`value`: Output<List<String>>) {
        this.kafkaVersions = value
    }

    @JvmName("droyrcgugjvvwrso")
    public suspend fun kafkaVersions(vararg values: Output<String>) {
        this.kafkaVersions = Output.all(values.asList())
    }

    /**
     * @param values List of Apache Kafka versions which can use this configuration.
     */
    @JvmName("lmntfgthrqycaacu")
    public suspend fun kafkaVersions(values: List<Output<String>>) {
        this.kafkaVersions = Output.all(values)
    }

    /**
     * @param value Name of the configuration.
     */
    @JvmName("agnijbhftwhwmtgy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Contents of the server.properties file. Supported properties are documented in the [MSK Developer Guide](https://docs.aws.amazon.com/msk/latest/developerguide/msk-configuration-properties.html).
     */
    @JvmName("inrkbmsxhedxdgpi")
    public suspend fun serverProperties(`value`: Output<String>) {
        this.serverProperties = value
    }

    /**
     * @param value Description of the configuration.
     */
    @JvmName("qfiyyrjidsqucklj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of Apache Kafka versions which can use this configuration.
     */
    @JvmName("yebipwuqsmhmsuvx")
    public suspend fun kafkaVersions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaVersions = mapped
    }

    /**
     * @param values List of Apache Kafka versions which can use this configuration.
     */
    @JvmName("selxbvvbpihhgddc")
    public suspend fun kafkaVersions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kafkaVersions = mapped
    }

    /**
     * @param value Name of the configuration.
     */
    @JvmName("tfyyalfquevfjsdn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Contents of the server.properties file. Supported properties are documented in the [MSK Developer Guide](https://docs.aws.amazon.com/msk/latest/developerguide/msk-configuration-properties.html).
     */
    @JvmName("qxscloadkgbfxjee")
    public suspend fun serverProperties(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverProperties = mapped
    }

    internal fun build(): ConfigurationArgs = ConfigurationArgs(
        description = description,
        kafkaVersions = kafkaVersions,
        name = name,
        serverProperties = serverProperties,
    )
}
