@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.aws.msk.kotlin.outputs.ReplicatorKafkaCluster
import com.pulumi.aws.msk.kotlin.outputs.ReplicatorReplicationInfoList
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.msk.kotlin.outputs.ReplicatorKafkaCluster.Companion.toKotlin as replicatorKafkaClusterToKotlin
import com.pulumi.aws.msk.kotlin.outputs.ReplicatorReplicationInfoList.Companion.toKotlin as replicatorReplicationInfoListToKotlin

/**
 * Builder for [Replicator].
 */
@PulumiTagMarker
public class ReplicatorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicatorArgs = ReplicatorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicatorArgsBuilder.() -> Unit) {
        val builder = ReplicatorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Replicator {
        val builtJavaResource = com.pulumi.aws.msk.Replicator(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Replicator(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Managed Streaming for Kafka Replicator.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.msk.Replicator("test", {
 *     replicatorName: "test-name",
 *     description: "test-description",
 *     serviceExecutionRoleArn: sourceAwsIamRole.arn,
 *     kafkaClusters: [
 *         {
 *             amazonMskCluster: {
 *                 mskClusterArn: source.arn,
 *             },
 *             vpcConfig: {
 *                 subnetIds: sourceAwsSubnet.map(__item => __item.id),
 *                 securityGroupsIds: [sourceAwsSecurityGroup&#46;id],
 *             },
 *         },
 *         {
 *             amazonMskCluster: {
 *                 mskClusterArn: target.arn,
 *             },
 *             vpcConfig: {
 *                 subnetIds: targetAwsSubnet.map(__item => __item.id),
 *                 securityGroupsIds: [targetAwsSecurityGroup&#46;id],
 *             },
 *         },
 *     ],
 *     replicationInfoList: {
 *         sourceKafkaClusterArn: source.arn,
 *         targetKafkaClusterArn: target.arn,
 *         targetCompressionType: "NONE",
 *         topicReplications: [{
 *             topicsToReplicates: ["&#46;*"],
 *         }],
 *         consumerGroupReplications: [{
 *             consumerGroupsToReplicates: ["&#46;*"],
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.msk.Replicator("test",
 *     replicator_name="test-name",
 *     description="test-description",
 *     service_execution_role_arn=source_aws_iam_role["arn"],
 *     kafka_clusters=[
 *         {
 *             "amazon_msk_cluster": {
 *                 "msk_cluster_arn": source["arn"],
 *             },
 *             "vpc_config": {
 *                 "subnet_ids": [__item["id"] for __item in source_aws_subnet],
 *                 "security_groups_ids": [source_aws_security_group["id"]],
 *             },
 *         },
 *         {
 *             "amazon_msk_cluster": {
 *                 "msk_cluster_arn": target["arn"],
 *             },
 *             "vpc_config": {
 *                 "subnet_ids": [__item["id"] for __item in target_aws_subnet],
 *                 "security_groups_ids": [target_aws_security_group["id"]],
 *             },
 *         },
 *     ],
 *     replication_info_list={
 *         "source_kafka_cluster_arn": source["arn"],
 *         "target_kafka_cluster_arn": target["arn"],
 *         "target_compression_type": "NONE",
 *         "topic_replications": [{
 *             "topics_to_replicates": ["&#46;*"],
 *         }],
 *         "consumer_group_replications": [{
 *             "consumer_groups_to_replicates": ["&#46;*"],
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Msk.Replicator("test", new()
 *     {
 *         ReplicatorName = "test-name",
 *         Description = "test-description",
 *         ServiceExecutionRoleArn = sourceAwsIamRole.Arn,
 *         KafkaClusters = new[]
 *         {
 *             new Aws.Msk.Inputs.ReplicatorKafkaClusterArgs
 *             {
 *                 AmazonMskCluster = new Aws.Msk.Inputs.ReplicatorKafkaClusterAmazonMskClusterArgs
 *                 {
 *                     MskClusterArn = source.Arn,
 *                 },
 *                 VpcConfig = new Aws.Msk.Inputs.ReplicatorKafkaClusterVpcConfigArgs
 *                 {
 *                     SubnetIds = sourceAwsSubnet.Select(__item => __item.Id).ToList(),
 *                     SecurityGroupsIds = new[]
 *                     {
 *                         sourceAwsSecurityGroup.Id,
 *                     },
 *                 },
 *             },
 *             new Aws.Msk.Inputs.ReplicatorKafkaClusterArgs
 *             {
 *                 AmazonMskCluster = new Aws.Msk.Inputs.ReplicatorKafkaClusterAmazonMskClusterArgs
 *                 {
 *                     MskClusterArn = target.Arn,
 *                 },
 *                 VpcConfig = new Aws.Msk.Inputs.ReplicatorKafkaClusterVpcConfigArgs
 *                 {
 *                     SubnetIds = targetAwsSubnet.Select(__item => __item.Id).ToList(),
 *                     SecurityGroupsIds = new[]
 *                     {
 *                         targetAwsSecurityGroup.Id,
 *                     },
 *                 },
 *             },
 *         },
 *         ReplicationInfoList = new Aws.Msk.Inputs.ReplicatorReplicationInfoListArgs
 *         {
 *             SourceKafkaClusterArn = source.Arn,
 *             TargetKafkaClusterArn = target.Arn,
 *             TargetCompressionType = "NONE",
 *             TopicReplications = new[]
 *             {
 *                 new Aws.Msk.Inputs.ReplicatorReplicationInfoListTopicReplicationArgs
 *                 {
 *                     TopicsToReplicates = new[]
 *                     {
 *                         ".*",
 *                     },
 *                 },
 *             },
 *             ConsumerGroupReplications = new[]
 *             {
 *                 new Aws.Msk.Inputs.ReplicatorReplicationInfoListConsumerGroupReplicationArgs
 *                 {
 *                     ConsumerGroupsToReplicates = new[]
 *                     {
 *                         ".*",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/msk"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := msk.NewReplicator(ctx, "test", &msk.ReplicatorArgs{
 * ReplicatorName: pulumi.String("test-name"),
 * Description: pulumi.String("test-description"),
 * ServiceExecutionRoleArn: pulumi.Any(sourceAwsIamRole.Arn),
 * KafkaClusters: msk.ReplicatorKafkaClusterArray{
 * &msk.ReplicatorKafkaClusterArgs{
 * AmazonMskCluster: &msk.ReplicatorKafkaClusterAmazonMskClusterArgs{
 * MskClusterArn: pulumi.Any(source.Arn),
 * },
 * VpcConfig: &msk.ReplicatorKafkaClusterVpcConfigArgs{
 * SubnetIds: []pulumi.String(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:9,27-48)),
 * SecurityGroupsIds: pulumi.StringArray{
 * sourceAwsSecurityGroup.Id,
 * },
 * },
 * },
 * &msk.ReplicatorKafkaClusterArgs{
 * AmazonMskCluster: &msk.ReplicatorKafkaClusterAmazonMskClusterArgs{
 * MskClusterArn: pulumi.Any(target.Arn),
 * },
 * VpcConfig: &msk.ReplicatorKafkaClusterVpcConfigArgs{
 * SubnetIds: []pulumi.String(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:17,27-48)),
 * SecurityGroupsIds: pulumi.StringArray{
 * targetAwsSecurityGroup.Id,
 * },
 * },
 * },
 * },
 * ReplicationInfoList: &msk.ReplicatorReplicationInfoListArgs{
 * SourceKafkaClusterArn: pulumi.Any(source.Arn),
 * TargetKafkaClusterArn: pulumi.Any(target.Arn),
 * TargetCompressionType: pulumi.String("NONE"),
 * TopicReplications: msk.ReplicatorReplicationInfoListTopicReplicationArray{
 * &msk.ReplicatorReplicationInfoListTopicReplicationArgs{
 * TopicsToReplicates: pulumi.StringArray{
 * pulumi.String(".*"),
 * },
 * },
 * },
 * ConsumerGroupReplications: msk.ReplicatorReplicationInfoListConsumerGroupReplicationArray{
 * &msk.ReplicatorReplicationInfoListConsumerGroupReplicationArgs{
 * ConsumerGroupsToReplicates: pulumi.StringArray{
 * pulumi.String(".*"),
 * },
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.msk.Replicator;
 * import com.pulumi.aws.msk.ReplicatorArgs;
 * import com.pulumi.aws.msk.inputs.ReplicatorKafkaClusterArgs;
 * import com.pulumi.aws.msk.inputs.ReplicatorKafkaClusterAmazonMskClusterArgs;
 * import com.pulumi.aws.msk.inputs.ReplicatorKafkaClusterVpcConfigArgs;
 * import com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Replicator("test", ReplicatorArgs.builder()
 *             .replicatorName("test-name")
 *             .description("test-description")
 *             .serviceExecutionRoleArn(sourceAwsIamRole.arn())
 *             .kafkaClusters(
 *                 ReplicatorKafkaClusterArgs.builder()
 *                     .amazonMskCluster(ReplicatorKafkaClusterAmazonMskClusterArgs.builder()
 *                         .mskClusterArn(source.arn())
 *                         .build())
 *                     .vpcConfig(ReplicatorKafkaClusterVpcConfigArgs.builder()
 *                         .subnetIds(sourceAwsSubnet.stream().map(element -> element.id()).collect(toList()))
 *                         .securityGroupsIds(sourceAwsSecurityGroup.id())
 *                         .build())
 *                     .build(),
 *                 ReplicatorKafkaClusterArgs.builder()
 *                     .amazonMskCluster(ReplicatorKafkaClusterAmazonMskClusterArgs.builder()
 *                         .mskClusterArn(target.arn())
 *                         .build())
 *                     .vpcConfig(ReplicatorKafkaClusterVpcConfigArgs.builder()
 *                         .subnetIds(targetAwsSubnet.stream().map(element -> element.id()).collect(toList()))
 *                         .securityGroupsIds(targetAwsSecurityGroup.id())
 *                         .build())
 *                     .build())
 *             .replicationInfoList(ReplicatorReplicationInfoListArgs.builder()
 *                 .sourceKafkaClusterArn(source.arn())
 *                 .targetKafkaClusterArn(target.arn())
 *                 .targetCompressionType("NONE")
 *                 .topicReplications(ReplicatorReplicationInfoListTopicReplicationArgs.builder()
 *                     .topicsToReplicates(".*")
 *                     .build())
 *                 .consumerGroupReplications(ReplicatorReplicationInfoListConsumerGroupReplicationArgs.builder()
 *                     .consumerGroupsToReplicates(".*")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MSK replicators using the replicator ARN. For example:
 * ```sh
 * $ pulumi import aws:msk/replicator:Replicator example arn:aws:kafka:us-west-2:123456789012:configuration/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
 * ```
 */
public class Replicator internal constructor(
    override val javaResource: com.pulumi.aws.msk.Replicator,
) : KotlinCustomResource(javaResource, ReplicatorMapper) {
    /**
     * ARN of the Replicator. Do not begin the description with "An", "The", "Defines", "Indicates", or "Specifies," as these are verbose. In other words, "Indicates the amount of storage," can be rewritten as "Amount of storage," without losing any information.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val currentVersion: Output<String>
        get() = javaResource.currentVersion().applyValue({ args0 -> args0 })

    /**
     * A summary description of the replicator.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of Kafka clusters which are targets of the replicator.
     */
    public val kafkaClusters: Output<List<ReplicatorKafkaCluster>>
        get() = javaResource.kafkaClusters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> replicatorKafkaClusterToKotlin(args0) })
            })
        })

    /**
     * A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
     */
    public val replicationInfoList: Output<ReplicatorReplicationInfoList>
        get() = javaResource.replicationInfoList().applyValue({ args0 ->
            args0.let({ args0 ->
                replicatorReplicationInfoListToKotlin(args0)
            })
        })

    /**
     * The name of the replicator.
     */
    public val replicatorName: Output<String>
        get() = javaResource.replicatorName().applyValue({ args0 -> args0 })

    /**
     * The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source and target clusters).
     */
    public val serviceExecutionRoleArn: Output<String>
        get() = javaResource.serviceExecutionRoleArn().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ReplicatorMapper : ResourceMapper<Replicator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.msk.Replicator::class == javaResource::class

    override fun map(javaResource: Resource): Replicator = Replicator(
        javaResource as
            com.pulumi.aws.msk.Replicator,
    )
}

/**
 * @see [Replicator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Replicator].
 */
public suspend fun replicator(name: String, block: suspend ReplicatorResourceBuilder.() -> Unit): Replicator {
    val builder = ReplicatorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Replicator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicator(name: String): Replicator {
    val builder = ReplicatorResourceBuilder()
    builder.name(name)
    return builder.build()
}
