@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.aws.msk.ReplicatorArgs.builder
import com.pulumi.aws.msk.kotlin.inputs.ReplicatorKafkaClusterArgs
import com.pulumi.aws.msk.kotlin.inputs.ReplicatorKafkaClusterArgsBuilder
import com.pulumi.aws.msk.kotlin.inputs.ReplicatorReplicationInfoListArgs
import com.pulumi.aws.msk.kotlin.inputs.ReplicatorReplicationInfoListArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Managed Streaming for Kafka Replicator.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.msk.Replicator("test", {
 *     replicatorName: "test-name",
 *     description: "test-description",
 *     serviceExecutionRoleArn: sourceAwsIamRole.arn,
 *     kafkaClusters: [
 *         {
 *             amazonMskCluster: {
 *                 mskClusterArn: source.arn,
 *             },
 *             vpcConfig: {
 *                 subnetIds: sourceAwsSubnet.map(__item => __item.id),
 *                 securityGroupsIds: [sourceAwsSecurityGroup&#46;id],
 *             },
 *         },
 *         {
 *             amazonMskCluster: {
 *                 mskClusterArn: target.arn,
 *             },
 *             vpcConfig: {
 *                 subnetIds: targetAwsSubnet.map(__item => __item.id),
 *                 securityGroupsIds: [targetAwsSecurityGroup&#46;id],
 *             },
 *         },
 *     ],
 *     replicationInfoList: {
 *         sourceKafkaClusterArn: source.arn,
 *         targetKafkaClusterArn: target.arn,
 *         targetCompressionType: "NONE",
 *         topicReplications: [{
 *             topicsToReplicates: ["&#46;*"],
 *         }],
 *         consumerGroupReplications: [{
 *             consumerGroupsToReplicates: ["&#46;*"],
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.msk.Replicator("test",
 *     replicator_name="test-name",
 *     description="test-description",
 *     service_execution_role_arn=source_aws_iam_role["arn"],
 *     kafka_clusters=[
 *         {
 *             "amazon_msk_cluster": {
 *                 "msk_cluster_arn": source["arn"],
 *             },
 *             "vpc_config": {
 *                 "subnet_ids": [__item["id"] for __item in source_aws_subnet],
 *                 "security_groups_ids": [source_aws_security_group["id"]],
 *             },
 *         },
 *         {
 *             "amazon_msk_cluster": {
 *                 "msk_cluster_arn": target["arn"],
 *             },
 *             "vpc_config": {
 *                 "subnet_ids": [__item["id"] for __item in target_aws_subnet],
 *                 "security_groups_ids": [target_aws_security_group["id"]],
 *             },
 *         },
 *     ],
 *     replication_info_list={
 *         "source_kafka_cluster_arn": source["arn"],
 *         "target_kafka_cluster_arn": target["arn"],
 *         "target_compression_type": "NONE",
 *         "topic_replications": [{
 *             "topics_to_replicates": ["&#46;*"],
 *         }],
 *         "consumer_group_replications": [{
 *             "consumer_groups_to_replicates": ["&#46;*"],
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Msk.Replicator("test", new()
 *     {
 *         ReplicatorName = "test-name",
 *         Description = "test-description",
 *         ServiceExecutionRoleArn = sourceAwsIamRole.Arn,
 *         KafkaClusters = new[]
 *         {
 *             new Aws.Msk.Inputs.ReplicatorKafkaClusterArgs
 *             {
 *                 AmazonMskCluster = new Aws.Msk.Inputs.ReplicatorKafkaClusterAmazonMskClusterArgs
 *                 {
 *                     MskClusterArn = source.Arn,
 *                 },
 *                 VpcConfig = new Aws.Msk.Inputs.ReplicatorKafkaClusterVpcConfigArgs
 *                 {
 *                     SubnetIds = sourceAwsSubnet.Select(__item => __item.Id).ToList(),
 *                     SecurityGroupsIds = new[]
 *                     {
 *                         sourceAwsSecurityGroup.Id,
 *                     },
 *                 },
 *             },
 *             new Aws.Msk.Inputs.ReplicatorKafkaClusterArgs
 *             {
 *                 AmazonMskCluster = new Aws.Msk.Inputs.ReplicatorKafkaClusterAmazonMskClusterArgs
 *                 {
 *                     MskClusterArn = target.Arn,
 *                 },
 *                 VpcConfig = new Aws.Msk.Inputs.ReplicatorKafkaClusterVpcConfigArgs
 *                 {
 *                     SubnetIds = targetAwsSubnet.Select(__item => __item.Id).ToList(),
 *                     SecurityGroupsIds = new[]
 *                     {
 *                         targetAwsSecurityGroup.Id,
 *                     },
 *                 },
 *             },
 *         },
 *         ReplicationInfoList = new Aws.Msk.Inputs.ReplicatorReplicationInfoListArgs
 *         {
 *             SourceKafkaClusterArn = source.Arn,
 *             TargetKafkaClusterArn = target.Arn,
 *             TargetCompressionType = "NONE",
 *             TopicReplications = new[]
 *             {
 *                 new Aws.Msk.Inputs.ReplicatorReplicationInfoListTopicReplicationArgs
 *                 {
 *                     TopicsToReplicates = new[]
 *                     {
 *                         ".*",
 *                     },
 *                 },
 *             },
 *             ConsumerGroupReplications = new[]
 *             {
 *                 new Aws.Msk.Inputs.ReplicatorReplicationInfoListConsumerGroupReplicationArgs
 *                 {
 *                     ConsumerGroupsToReplicates = new[]
 *                     {
 *                         ".*",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/msk"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := msk.NewReplicator(ctx, "test", &msk.ReplicatorArgs{
 * ReplicatorName: pulumi.String("test-name"),
 * Description: pulumi.String("test-description"),
 * ServiceExecutionRoleArn: pulumi.Any(sourceAwsIamRole.Arn),
 * KafkaClusters: msk.ReplicatorKafkaClusterArray{
 * &msk.ReplicatorKafkaClusterArgs{
 * AmazonMskCluster: &msk.ReplicatorKafkaClusterAmazonMskClusterArgs{
 * MskClusterArn: pulumi.Any(source.Arn),
 * },
 * VpcConfig: &msk.ReplicatorKafkaClusterVpcConfigArgs{
 * SubnetIds: []pulumi.String(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:9,27-48)),
 * SecurityGroupsIds: pulumi.StringArray{
 * sourceAwsSecurityGroup.Id,
 * },
 * },
 * },
 * &msk.ReplicatorKafkaClusterArgs{
 * AmazonMskCluster: &msk.ReplicatorKafkaClusterAmazonMskClusterArgs{
 * MskClusterArn: pulumi.Any(target.Arn),
 * },
 * VpcConfig: &msk.ReplicatorKafkaClusterVpcConfigArgs{
 * SubnetIds: []pulumi.String(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:17,27-48)),
 * SecurityGroupsIds: pulumi.StringArray{
 * targetAwsSecurityGroup.Id,
 * },
 * },
 * },
 * },
 * ReplicationInfoList: &msk.ReplicatorReplicationInfoListArgs{
 * SourceKafkaClusterArn: pulumi.Any(source.Arn),
 * TargetKafkaClusterArn: pulumi.Any(target.Arn),
 * TargetCompressionType: pulumi.String("NONE"),
 * TopicReplications: msk.ReplicatorReplicationInfoListTopicReplicationArray{
 * &msk.ReplicatorReplicationInfoListTopicReplicationArgs{
 * TopicsToReplicates: pulumi.StringArray{
 * pulumi.String(".*"),
 * },
 * },
 * },
 * ConsumerGroupReplications: msk.ReplicatorReplicationInfoListConsumerGroupReplicationArray{
 * &msk.ReplicatorReplicationInfoListConsumerGroupReplicationArgs{
 * ConsumerGroupsToReplicates: pulumi.StringArray{
 * pulumi.String(".*"),
 * },
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.msk.Replicator;
 * import com.pulumi.aws.msk.ReplicatorArgs;
 * import com.pulumi.aws.msk.inputs.ReplicatorKafkaClusterArgs;
 * import com.pulumi.aws.msk.inputs.ReplicatorKafkaClusterAmazonMskClusterArgs;
 * import com.pulumi.aws.msk.inputs.ReplicatorKafkaClusterVpcConfigArgs;
 * import com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Replicator("test", ReplicatorArgs.builder()
 *             .replicatorName("test-name")
 *             .description("test-description")
 *             .serviceExecutionRoleArn(sourceAwsIamRole.arn())
 *             .kafkaClusters(
 *                 ReplicatorKafkaClusterArgs.builder()
 *                     .amazonMskCluster(ReplicatorKafkaClusterAmazonMskClusterArgs.builder()
 *                         .mskClusterArn(source.arn())
 *                         .build())
 *                     .vpcConfig(ReplicatorKafkaClusterVpcConfigArgs.builder()
 *                         .subnetIds(sourceAwsSubnet.stream().map(element -> element.id()).collect(toList()))
 *                         .securityGroupsIds(sourceAwsSecurityGroup.id())
 *                         .build())
 *                     .build(),
 *                 ReplicatorKafkaClusterArgs.builder()
 *                     .amazonMskCluster(ReplicatorKafkaClusterAmazonMskClusterArgs.builder()
 *                         .mskClusterArn(target.arn())
 *                         .build())
 *                     .vpcConfig(ReplicatorKafkaClusterVpcConfigArgs.builder()
 *                         .subnetIds(targetAwsSubnet.stream().map(element -> element.id()).collect(toList()))
 *                         .securityGroupsIds(targetAwsSecurityGroup.id())
 *                         .build())
 *                     .build())
 *             .replicationInfoList(ReplicatorReplicationInfoListArgs.builder()
 *                 .sourceKafkaClusterArn(source.arn())
 *                 .targetKafkaClusterArn(target.arn())
 *                 .targetCompressionType("NONE")
 *                 .topicReplications(ReplicatorReplicationInfoListTopicReplicationArgs.builder()
 *                     .topicsToReplicates(".*")
 *                     .build())
 *                 .consumerGroupReplications(ReplicatorReplicationInfoListConsumerGroupReplicationArgs.builder()
 *                     .consumerGroupsToReplicates(".*")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MSK replicators using the replicator ARN. For example:
 * ```sh
 * $ pulumi import aws:msk/replicator:Replicator example arn:aws:kafka:us-west-2:123456789012:configuration/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
 * ```
 * @property description A summary description of the replicator.
 * @property kafkaClusters A list of Kafka clusters which are targets of the replicator.
 * @property replicationInfoList A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
 * @property replicatorName The name of the replicator.
 * @property serviceExecutionRoleArn The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source and target clusters).
 * @property tags
 */
public data class ReplicatorArgs(
    public val description: Output<String>? = null,
    public val kafkaClusters: Output<List<ReplicatorKafkaClusterArgs>>? = null,
    public val replicationInfoList: Output<ReplicatorReplicationInfoListArgs>? = null,
    public val replicatorName: Output<String>? = null,
    public val serviceExecutionRoleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.ReplicatorArgs> {
    override fun toJava(): com.pulumi.aws.msk.ReplicatorArgs =
        com.pulumi.aws.msk.ReplicatorArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .kafkaClusters(
                kafkaClusters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .replicationInfoList(
                replicationInfoList?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .replicatorName(replicatorName?.applyValue({ args0 -> args0 }))
            .serviceExecutionRoleArn(serviceExecutionRoleArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ReplicatorArgs].
 */
@PulumiTagMarker
public class ReplicatorArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var kafkaClusters: Output<List<ReplicatorKafkaClusterArgs>>? = null

    private var replicationInfoList: Output<ReplicatorReplicationInfoListArgs>? = null

    private var replicatorName: Output<String>? = null

    private var serviceExecutionRoleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A summary description of the replicator.
     */
    @JvmName("tegcmfppbnaceyav")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A list of Kafka clusters which are targets of the replicator.
     */
    @JvmName("ngsidclapafitkxo")
    public suspend fun kafkaClusters(`value`: Output<List<ReplicatorKafkaClusterArgs>>) {
        this.kafkaClusters = value
    }

    @JvmName("pnmxbtsfhetldcnx")
    public suspend fun kafkaClusters(vararg values: Output<ReplicatorKafkaClusterArgs>) {
        this.kafkaClusters = Output.all(values.asList())
    }

    /**
     * @param values A list of Kafka clusters which are targets of the replicator.
     */
    @JvmName("mxmfqwtqlocsffmw")
    public suspend fun kafkaClusters(values: List<Output<ReplicatorKafkaClusterArgs>>) {
        this.kafkaClusters = Output.all(values)
    }

    /**
     * @param value A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
     */
    @JvmName("ijxcvdixfmfedley")
    public suspend fun replicationInfoList(`value`: Output<ReplicatorReplicationInfoListArgs>) {
        this.replicationInfoList = value
    }

    /**
     * @param value The name of the replicator.
     */
    @JvmName("ujmsdcnipcvcffpn")
    public suspend fun replicatorName(`value`: Output<String>) {
        this.replicatorName = value
    }

    /**
     * @param value The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source and target clusters).
     */
    @JvmName("svktuetocyvxvrsv")
    public suspend fun serviceExecutionRoleArn(`value`: Output<String>) {
        this.serviceExecutionRoleArn = value
    }

    /**
     * @param value
     */
    @JvmName("puvmoopmjfxgquxh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A summary description of the replicator.
     */
    @JvmName("eqbttxwyfxwccmhh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A list of Kafka clusters which are targets of the replicator.
     */
    @JvmName("mpftkosctmplxsoq")
    public suspend fun kafkaClusters(`value`: List<ReplicatorKafkaClusterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaClusters = mapped
    }

    /**
     * @param argument A list of Kafka clusters which are targets of the replicator.
     */
    @JvmName("eiwwdtuhnxuurhgl")
    public suspend fun kafkaClusters(argument: List<suspend ReplicatorKafkaClusterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReplicatorKafkaClusterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.kafkaClusters = mapped
    }

    /**
     * @param argument A list of Kafka clusters which are targets of the replicator.
     */
    @JvmName("jmdipbrmyqjukwyf")
    public suspend fun kafkaClusters(vararg argument: suspend ReplicatorKafkaClusterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReplicatorKafkaClusterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.kafkaClusters = mapped
    }

    /**
     * @param argument A list of Kafka clusters which are targets of the replicator.
     */
    @JvmName("dyebjtbverwhiggx")
    public suspend fun kafkaClusters(argument: suspend ReplicatorKafkaClusterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ReplicatorKafkaClusterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.kafkaClusters = mapped
    }

    /**
     * @param values A list of Kafka clusters which are targets of the replicator.
     */
    @JvmName("omcuaybgvhmlqwfo")
    public suspend fun kafkaClusters(vararg values: ReplicatorKafkaClusterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kafkaClusters = mapped
    }

    /**
     * @param value A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
     */
    @JvmName("hhaedykwsrtdbglc")
    public suspend fun replicationInfoList(`value`: ReplicatorReplicationInfoListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationInfoList = mapped
    }

    /**
     * @param argument A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
     */
    @JvmName("dueffoknoapogoyv")
    public suspend fun replicationInfoList(argument: suspend ReplicatorReplicationInfoListArgsBuilder.() -> Unit) {
        val toBeMapped = ReplicatorReplicationInfoListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.replicationInfoList = mapped
    }

    /**
     * @param value The name of the replicator.
     */
    @JvmName("mjqbytlqraptylti")
    public suspend fun replicatorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicatorName = mapped
    }

    /**
     * @param value The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source and target clusters).
     */
    @JvmName("fdrerxsungouufjk")
    public suspend fun serviceExecutionRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceExecutionRoleArn = mapped
    }

    /**
     * @param value
     */
    @JvmName("xyujlqonnoudblfq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("hemhrqwcpmvxsros")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ReplicatorArgs = ReplicatorArgs(
        description = description,
        kafkaClusters = kafkaClusters,
        replicationInfoList = replicationInfoList,
        replicatorName = replicatorName,
        serviceExecutionRoleArn = serviceExecutionRoleArn,
        tags = tags,
    )
}
