@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.aws.msk.kotlin.outputs.ServerlessClusterClientAuthentication
import com.pulumi.aws.msk.kotlin.outputs.ServerlessClusterVpcConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.msk.kotlin.outputs.ServerlessClusterClientAuthentication.Companion.toKotlin as serverlessClusterClientAuthenticationToKotlin
import com.pulumi.aws.msk.kotlin.outputs.ServerlessClusterVpcConfig.Companion.toKotlin as serverlessClusterVpcConfigToKotlin

/**
 * Builder for [ServerlessCluster].
 */
@PulumiTagMarker
public class ServerlessClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerlessClusterArgs = ServerlessClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerlessClusterArgsBuilder.() -> Unit) {
        val builder = ServerlessClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerlessCluster {
        val builtJavaResource = com.pulumi.aws.msk.ServerlessCluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServerlessCluster(builtJavaResource)
    }
}

/**
 * Manages an Amazon MSK Serverless cluster.
 * > **Note:** To manage a _provisioned_ Amazon MSK cluster, use the `aws.msk.Cluster` resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.msk.ServerlessCluster("example", {
 *     clusterName: "Example",
 *     vpcConfigs: [{
 *         subnetIds: exampleAwsSubnet.map(__item => __item.id),
 *         securityGroupIds: [exampleAwsSecurityGroup&#46;id],
 *     }],
 *     clientAuthentication: {
 *         sasl: {
 *             iam: {
 *                 enabled: true,
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.msk.ServerlessCluster("example",
 *     cluster_name="Example",
 *     vpc_configs=[{
 *         "subnet_ids": [__item["id"] for __item in example_aws_subnet],
 *         "security_group_ids": [example_aws_security_group["id"]],
 *     }],
 *     client_authentication={
 *         "sasl": {
 *             "iam": {
 *                 "enabled": True,
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Msk.ServerlessCluster("example", new()
 *     {
 *         ClusterName = "Example",
 *         VpcConfigs = new[]
 *         {
 *             new Aws.Msk.Inputs.ServerlessClusterVpcConfigArgs
 *             {
 *                 SubnetIds = exampleAwsSubnet.Select(__item => __item.Id).ToList(),
 *                 SecurityGroupIds = new[]
 *                 {
 *                     exampleAwsSecurityGroup.Id,
 *                 },
 *             },
 *         },
 *         ClientAuthentication = new Aws.Msk.Inputs.ServerlessClusterClientAuthenticationArgs
 *         {
 *             Sasl = new Aws.Msk.Inputs.ServerlessClusterClientAuthenticationSaslArgs
 *             {
 *                 Iam = new Aws.Msk.Inputs.ServerlessClusterClientAuthenticationSaslIamArgs
 *                 {
 *                     Enabled = true,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/msk"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := msk.NewServerlessCluster(ctx, "example", &msk.ServerlessClusterArgs{
 * ClusterName: pulumi.String("Example"),
 * VpcConfigs: msk.ServerlessClusterVpcConfigArray{
 * &msk.ServerlessClusterVpcConfigArgs{
 * SubnetIds: []pulumi.String(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:3,24-46)),
 * SecurityGroupIds: pulumi.StringArray{
 * exampleAwsSecurityGroup.Id,
 * },
 * },
 * },
 * ClientAuthentication: &msk.ServerlessClusterClientAuthenticationArgs{
 * Sasl: &msk.ServerlessClusterClientAuthenticationSaslArgs{
 * Iam: &msk.ServerlessClusterClientAuthenticationSaslIamArgs{
 * Enabled: pulumi.Bool(true),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.msk.ServerlessCluster;
 * import com.pulumi.aws.msk.ServerlessClusterArgs;
 * import com.pulumi.aws.msk.inputs.ServerlessClusterVpcConfigArgs;
 * import com.pulumi.aws.msk.inputs.ServerlessClusterClientAuthenticationArgs;
 * import com.pulumi.aws.msk.inputs.ServerlessClusterClientAuthenticationSaslArgs;
 * import com.pulumi.aws.msk.inputs.ServerlessClusterClientAuthenticationSaslIamArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessCluster("example", ServerlessClusterArgs.builder()
 *             .clusterName("Example")
 *             .vpcConfigs(ServerlessClusterVpcConfigArgs.builder()
 *                 .subnetIds(exampleAwsSubnet.stream().map(element -> element.id()).collect(toList()))
 *                 .securityGroupIds(exampleAwsSecurityGroup.id())
 *                 .build())
 *             .clientAuthentication(ServerlessClusterClientAuthenticationArgs.builder()
 *                 .sasl(ServerlessClusterClientAuthenticationSaslArgs.builder()
 *                     .iam(ServerlessClusterClientAuthenticationSaslIamArgs.builder()
 *                         .enabled(true)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MSK serverless clusters using the cluster `arn`. For example:
 * ```sh
 * $ pulumi import aws:msk/serverlessCluster:ServerlessCluster example arn:aws:kafka:us-west-2:123456789012:cluster/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
 * ```
 */
public class ServerlessCluster internal constructor(
    override val javaResource: com.pulumi.aws.msk.ServerlessCluster,
) : KotlinCustomResource(javaResource, ServerlessClusterMapper) {
    /**
     * The ARN of the serverless cluster.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies client authentication information for the serverless cluster. See below.
     */
    public val clientAuthentication: Output<ServerlessClusterClientAuthentication>
        get() = javaResource.clientAuthentication().applyValue({ args0 ->
            args0.let({ args0 ->
                serverlessClusterClientAuthenticationToKotlin(args0)
            })
        })

    /**
     * The name of the serverless cluster.
     */
    public val clusterName: Output<String>
        get() = javaResource.clusterName().applyValue({ args0 -> args0 })

    /**
     * UUID of the serverless cluster, for use in IAM policies.
     */
    public val clusterUuid: Output<String>
        get() = javaResource.clusterUuid().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * VPC configuration information. See below.
     */
    public val vpcConfigs: Output<List<ServerlessClusterVpcConfig>>
        get() = javaResource.vpcConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serverlessClusterVpcConfigToKotlin(args0)
                })
            })
        })
}

public object ServerlessClusterMapper : ResourceMapper<ServerlessCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.msk.ServerlessCluster::class == javaResource::class

    override fun map(javaResource: Resource): ServerlessCluster = ServerlessCluster(
        javaResource as
            com.pulumi.aws.msk.ServerlessCluster,
    )
}

/**
 * @see [ServerlessCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerlessCluster].
 */
public suspend fun serverlessCluster(
    name: String,
    block: suspend ServerlessClusterResourceBuilder.() -> Unit,
): ServerlessCluster {
    val builder = ServerlessClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerlessCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverlessCluster(name: String): ServerlessCluster {
    val builder = ServerlessClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
