@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.aws.msk.ServerlessClusterArgs.builder
import com.pulumi.aws.msk.kotlin.inputs.ServerlessClusterClientAuthenticationArgs
import com.pulumi.aws.msk.kotlin.inputs.ServerlessClusterClientAuthenticationArgsBuilder
import com.pulumi.aws.msk.kotlin.inputs.ServerlessClusterVpcConfigArgs
import com.pulumi.aws.msk.kotlin.inputs.ServerlessClusterVpcConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon MSK Serverless cluster.
 * > **Note:** To manage a _provisioned_ Amazon MSK cluster, use the `aws.msk.Cluster` resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.msk.ServerlessCluster("example", {
 *     clusterName: "Example",
 *     vpcConfigs: [{
 *         subnetIds: exampleAwsSubnet.map(__item => __item.id),
 *         securityGroupIds: [exampleAwsSecurityGroup&#46;id],
 *     }],
 *     clientAuthentication: {
 *         sasl: {
 *             iam: {
 *                 enabled: true,
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.msk.ServerlessCluster("example",
 *     cluster_name="Example",
 *     vpc_configs=[{
 *         "subnet_ids": [__item["id"] for __item in example_aws_subnet],
 *         "security_group_ids": [example_aws_security_group["id"]],
 *     }],
 *     client_authentication={
 *         "sasl": {
 *             "iam": {
 *                 "enabled": True,
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Msk.ServerlessCluster("example", new()
 *     {
 *         ClusterName = "Example",
 *         VpcConfigs = new[]
 *         {
 *             new Aws.Msk.Inputs.ServerlessClusterVpcConfigArgs
 *             {
 *                 SubnetIds = exampleAwsSubnet.Select(__item => __item.Id).ToList(),
 *                 SecurityGroupIds = new[]
 *                 {
 *                     exampleAwsSecurityGroup.Id,
 *                 },
 *             },
 *         },
 *         ClientAuthentication = new Aws.Msk.Inputs.ServerlessClusterClientAuthenticationArgs
 *         {
 *             Sasl = new Aws.Msk.Inputs.ServerlessClusterClientAuthenticationSaslArgs
 *             {
 *                 Iam = new Aws.Msk.Inputs.ServerlessClusterClientAuthenticationSaslIamArgs
 *                 {
 *                     Enabled = true,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/msk"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := msk.NewServerlessCluster(ctx, "example", &msk.ServerlessClusterArgs{
 * ClusterName: pulumi.String("Example"),
 * VpcConfigs: msk.ServerlessClusterVpcConfigArray{
 * &msk.ServerlessClusterVpcConfigArgs{
 * SubnetIds: []pulumi.String(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:3,24-46)),
 * SecurityGroupIds: pulumi.StringArray{
 * exampleAwsSecurityGroup.Id,
 * },
 * },
 * },
 * ClientAuthentication: &msk.ServerlessClusterClientAuthenticationArgs{
 * Sasl: &msk.ServerlessClusterClientAuthenticationSaslArgs{
 * Iam: &msk.ServerlessClusterClientAuthenticationSaslIamArgs{
 * Enabled: pulumi.Bool(true),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.msk.ServerlessCluster;
 * import com.pulumi.aws.msk.ServerlessClusterArgs;
 * import com.pulumi.aws.msk.inputs.ServerlessClusterVpcConfigArgs;
 * import com.pulumi.aws.msk.inputs.ServerlessClusterClientAuthenticationArgs;
 * import com.pulumi.aws.msk.inputs.ServerlessClusterClientAuthenticationSaslArgs;
 * import com.pulumi.aws.msk.inputs.ServerlessClusterClientAuthenticationSaslIamArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessCluster("example", ServerlessClusterArgs.builder()
 *             .clusterName("Example")
 *             .vpcConfigs(ServerlessClusterVpcConfigArgs.builder()
 *                 .subnetIds(exampleAwsSubnet.stream().map(element -> element.id()).collect(toList()))
 *                 .securityGroupIds(exampleAwsSecurityGroup.id())
 *                 .build())
 *             .clientAuthentication(ServerlessClusterClientAuthenticationArgs.builder()
 *                 .sasl(ServerlessClusterClientAuthenticationSaslArgs.builder()
 *                     .iam(ServerlessClusterClientAuthenticationSaslIamArgs.builder()
 *                         .enabled(true)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MSK serverless clusters using the cluster `arn`. For example:
 * ```sh
 * $ pulumi import aws:msk/serverlessCluster:ServerlessCluster example arn:aws:kafka:us-west-2:123456789012:cluster/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
 * ```
 * @property clientAuthentication Specifies client authentication information for the serverless cluster. See below.
 * @property clusterName The name of the serverless cluster.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcConfigs VPC configuration information. See below.
 */
public data class ServerlessClusterArgs(
    public val clientAuthentication: Output<ServerlessClusterClientAuthenticationArgs>? = null,
    public val clusterName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcConfigs: Output<List<ServerlessClusterVpcConfigArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.ServerlessClusterArgs> {
    override fun toJava(): com.pulumi.aws.msk.ServerlessClusterArgs =
        com.pulumi.aws.msk.ServerlessClusterArgs.builder()
            .clientAuthentication(
                clientAuthentication?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcConfigs(
                vpcConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ServerlessClusterArgs].
 */
@PulumiTagMarker
public class ServerlessClusterArgsBuilder internal constructor() {
    private var clientAuthentication: Output<ServerlessClusterClientAuthenticationArgs>? = null

    private var clusterName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcConfigs: Output<List<ServerlessClusterVpcConfigArgs>>? = null

    /**
     * @param value Specifies client authentication information for the serverless cluster. See below.
     */
    @JvmName("daixveavximpvwdc")
    public suspend fun clientAuthentication(`value`: Output<ServerlessClusterClientAuthenticationArgs>) {
        this.clientAuthentication = value
    }

    /**
     * @param value The name of the serverless cluster.
     */
    @JvmName("cuddqkplgmxivqas")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fbpmksfjvwnbtmrn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value VPC configuration information. See below.
     */
    @JvmName("nokyeexjbcxoxouo")
    public suspend fun vpcConfigs(`value`: Output<List<ServerlessClusterVpcConfigArgs>>) {
        this.vpcConfigs = value
    }

    @JvmName("rjqpvsvpecofksgs")
    public suspend fun vpcConfigs(vararg values: Output<ServerlessClusterVpcConfigArgs>) {
        this.vpcConfigs = Output.all(values.asList())
    }

    /**
     * @param values VPC configuration information. See below.
     */
    @JvmName("nddxwhtipcvqbceb")
    public suspend fun vpcConfigs(values: List<Output<ServerlessClusterVpcConfigArgs>>) {
        this.vpcConfigs = Output.all(values)
    }

    /**
     * @param value Specifies client authentication information for the serverless cluster. See below.
     */
    @JvmName("txqbplnwxdlwxuun")
    public suspend fun clientAuthentication(`value`: ServerlessClusterClientAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAuthentication = mapped
    }

    /**
     * @param argument Specifies client authentication information for the serverless cluster. See below.
     */
    @JvmName("ikqefrjeylatlxxp")
    public suspend fun clientAuthentication(argument: suspend ServerlessClusterClientAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = ServerlessClusterClientAuthenticationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.clientAuthentication = mapped
    }

    /**
     * @param value The name of the serverless cluster.
     */
    @JvmName("axqsqtwpjovpdaup")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yuwcndralbvgvpya")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gtaecgsbppeyfoeq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value VPC configuration information. See below.
     */
    @JvmName("thyvisfppjagsgeh")
    public suspend fun vpcConfigs(`value`: List<ServerlessClusterVpcConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfigs = mapped
    }

    /**
     * @param argument VPC configuration information. See below.
     */
    @JvmName("sooefnndocbcqanx")
    public suspend fun vpcConfigs(argument: List<suspend ServerlessClusterVpcConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServerlessClusterVpcConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpcConfigs = mapped
    }

    /**
     * @param argument VPC configuration information. See below.
     */
    @JvmName("ilwxhygqwgwdkwbn")
    public suspend fun vpcConfigs(vararg argument: suspend ServerlessClusterVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServerlessClusterVpcConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpcConfigs = mapped
    }

    /**
     * @param argument VPC configuration information. See below.
     */
    @JvmName("thyvdfdmvioltbtt")
    public suspend fun vpcConfigs(argument: suspend ServerlessClusterVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServerlessClusterVpcConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vpcConfigs = mapped
    }

    /**
     * @param values VPC configuration information. See below.
     */
    @JvmName("hflicrgaecvefwsc")
    public suspend fun vpcConfigs(vararg values: ServerlessClusterVpcConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcConfigs = mapped
    }

    internal fun build(): ServerlessClusterArgs = ServerlessClusterArgs(
        clientAuthentication = clientAuthentication,
        clusterName = clusterName,
        tags = tags,
        vpcConfigs = vpcConfigs,
    )
}
