@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [VpcConnection].
 */
@PulumiTagMarker
public class VpcConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcConnectionArgs = VpcConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcConnectionArgsBuilder.() -> Unit) {
        val builder = VpcConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcConnection {
        val builtJavaResource = com.pulumi.aws.msk.VpcConnection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcConnection(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Managed Streaming for Kafka VPC Connection.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.msk.VpcConnection("test", {
 *     authentication: "SASL_IAM",
 *     targetClusterArn: "aws_msk_cluster.arn",
 *     vpcId: testAwsVpc.id,
 *     clientSubnets: testAwsSubnet.map(__item => __item.id),
 *     securityGroups: [testAwsSecurityGroup&#46;id],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.msk.VpcConnection("test",
 *     authentication="SASL_IAM",
 *     target_cluster_arn="aws_msk_cluster.arn",
 *     vpc_id=test_aws_vpc["id"],
 *     client_subnets=[__item["id"] for __item in test_aws_subnet],
 *     security_groups=[test_aws_security_group["id"]])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Msk.VpcConnection("test", new()
 *     {
 *         Authentication = "SASL_IAM",
 *         TargetClusterArn = "aws_msk_cluster.arn",
 *         VpcId = testAwsVpc.Id,
 *         ClientSubnets = testAwsSubnet.Select(__item => __item.Id).ToList(),
 *         SecurityGroups = new[]
 *         {
 *             testAwsSecurityGroup.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/msk"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range testAwsSubnet {
 * splat0 = append(splat0, val0.Id)
 * }
 * _, err := msk.NewVpcConnection(ctx, "test", &msk.VpcConnectionArgs{
 * Authentication: pulumi.String("SASL_IAM"),
 * TargetClusterArn: pulumi.String("aws_msk_cluster.arn"),
 * VpcId: pulumi.Any(testAwsVpc.Id),
 * ClientSubnets: toPulumiArray(splat0),
 * SecurityGroups: pulumi.StringArray{
 * testAwsSecurityGroup.Id,
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.msk.VpcConnection;
 * import com.pulumi.aws.msk.VpcConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new VpcConnection("test", VpcConnectionArgs.builder()
 *             .authentication("SASL_IAM")
 *             .targetClusterArn("aws_msk_cluster.arn")
 *             .vpcId(testAwsVpc.id())
 *             .clientSubnets(testAwsSubnet.stream().map(element -> element.id()).collect(toList()))
 *             .securityGroups(testAwsSecurityGroup.id())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MSK configurations using the configuration ARN. For example:
 * ```sh
 * $ pulumi import aws:msk/vpcConnection:VpcConnection example arn:aws:kafka:eu-west-2:123456789012:vpc-connection/123456789012/example/38173259-79cd-4ee8-87f3-682ea6023f48-2
 * ```
 */
public class VpcConnection internal constructor(
    override val javaResource: com.pulumi.aws.msk.VpcConnection,
) : KotlinCustomResource(javaResource, VpcConnectionMapper) {
    /**
     * Amazon Resource Name (ARN) of the VPC connection.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The authentication type for the client VPC connection. Specify one of these auth type strings: SASL_IAM, SASL_SCRAM, or TLS.
     */
    public val authentication: Output<String>
        get() = javaResource.authentication().applyValue({ args0 -> args0 })

    /**
     * The list of subnets in the client VPC to connect to.
     */
    public val clientSubnets: Output<List<String>>
        get() = javaResource.clientSubnets().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The security groups to attach to the ENIs for the broker nodes.
     */
    public val securityGroups: Output<List<String>>
        get() = javaResource.securityGroups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The Amazon Resource Name (ARN) of the cluster.
     */
    public val targetClusterArn: Output<String>
        get() = javaResource.targetClusterArn().applyValue({ args0 -> args0 })

    /**
     * The VPC ID of the remote client.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object VpcConnectionMapper : ResourceMapper<VpcConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.msk.VpcConnection::class == javaResource::class

    override fun map(javaResource: Resource): VpcConnection = VpcConnection(
        javaResource as
            com.pulumi.aws.msk.VpcConnection,
    )
}

/**
 * @see [VpcConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcConnection].
 */
public suspend fun vpcConnection(
    name: String,
    block: suspend VpcConnectionResourceBuilder.() -> Unit,
): VpcConnection {
    val builder = VpcConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcConnection(name: String): VpcConnection {
    val builder = VpcConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
