@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property azDistribution The distribution of broker nodes across availability zones ([documentation](https://docs.aws.amazon.com/msk/1.0/apireference/clusters.html#clusters-model-brokerazdistribution)). Currently the only valid value is `DEFAULT`.
 * @property clientSubnets A list of subnets to connect to in client VPC ([documentation](https://docs.aws.amazon.com/msk/1.0/apireference/clusters.html#clusters-prop-brokernodegroupinfo-clientsubnets)).
 * @property connectivityInfo Information about the cluster access configuration. See below. For security reasons, you can't turn on public access while creating an MSK cluster. However, you can update an existing cluster to make it publicly accessible. You can also create a new cluster and then update it to make it publicly accessible ([documentation](https://docs.aws.amazon.com/msk/latest/developerguide/public-access.html)).
 * @property instanceType Specify the instance type to use for the kafka brokersE.g., kafka.m5.large. ([Pricing info](https://aws.amazon.com/msk/pricing/))
 * @property securityGroups A list of the security groups to associate with the elastic network interfaces to control who can communicate with the cluster.
 * @property storageInfo A block that contains information about storage volumes attached to MSK broker nodes. See below.
 */
public data class ClusterBrokerNodeGroupInfoArgs(
    public val azDistribution: Output<String>? = null,
    public val clientSubnets: Output<List<String>>,
    public val connectivityInfo: Output<ClusterBrokerNodeGroupInfoConnectivityInfoArgs>? = null,
    public val instanceType: Output<String>,
    public val securityGroups: Output<List<String>>,
    public val storageInfo: Output<ClusterBrokerNodeGroupInfoStorageInfoArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoArgs =
        com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoArgs.builder()
            .azDistribution(azDistribution?.applyValue({ args0 -> args0 }))
            .clientSubnets(clientSubnets.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectivityInfo(connectivityInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .storageInfo(storageInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ClusterBrokerNodeGroupInfoArgs].
 */
@PulumiTagMarker
public class ClusterBrokerNodeGroupInfoArgsBuilder internal constructor() {
    private var azDistribution: Output<String>? = null

    private var clientSubnets: Output<List<String>>? = null

    private var connectivityInfo: Output<ClusterBrokerNodeGroupInfoConnectivityInfoArgs>? = null

    private var instanceType: Output<String>? = null

    private var securityGroups: Output<List<String>>? = null

    private var storageInfo: Output<ClusterBrokerNodeGroupInfoStorageInfoArgs>? = null

    /**
     * @param value The distribution of broker nodes across availability zones ([documentation](https://docs.aws.amazon.com/msk/1.0/apireference/clusters.html#clusters-model-brokerazdistribution)). Currently the only valid value is `DEFAULT`.
     */
    @JvmName("wivgqnocevjlcrvy")
    public suspend fun azDistribution(`value`: Output<String>) {
        this.azDistribution = value
    }

    /**
     * @param value A list of subnets to connect to in client VPC ([documentation](https://docs.aws.amazon.com/msk/1.0/apireference/clusters.html#clusters-prop-brokernodegroupinfo-clientsubnets)).
     */
    @JvmName("igtqiefpbsqiwgik")
    public suspend fun clientSubnets(`value`: Output<List<String>>) {
        this.clientSubnets = value
    }

    @JvmName("gvwpvdnijdskyhur")
    public suspend fun clientSubnets(vararg values: Output<String>) {
        this.clientSubnets = Output.all(values.asList())
    }

    /**
     * @param values A list of subnets to connect to in client VPC ([documentation](https://docs.aws.amazon.com/msk/1.0/apireference/clusters.html#clusters-prop-brokernodegroupinfo-clientsubnets)).
     */
    @JvmName("pfrhdbknlchhtpbh")
    public suspend fun clientSubnets(values: List<Output<String>>) {
        this.clientSubnets = Output.all(values)
    }

    /**
     * @param value Information about the cluster access configuration. See below. For security reasons, you can't turn on public access while creating an MSK cluster. However, you can update an existing cluster to make it publicly accessible. You can also create a new cluster and then update it to make it publicly accessible ([documentation](https://docs.aws.amazon.com/msk/latest/developerguide/public-access.html)).
     */
    @JvmName("fghgnywulorbwwnp")
    public suspend fun connectivityInfo(`value`: Output<ClusterBrokerNodeGroupInfoConnectivityInfoArgs>) {
        this.connectivityInfo = value
    }

    /**
     * @param value Specify the instance type to use for the kafka brokersE.g., kafka.m5.large. ([Pricing info](https://aws.amazon.com/msk/pricing/))
     */
    @JvmName("ptslvoiligemsyce")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value A list of the security groups to associate with the elastic network interfaces to control who can communicate with the cluster.
     */
    @JvmName("xpywdwealxekoadp")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("gcdsfnycfjuqcxeq")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values A list of the security groups to associate with the elastic network interfaces to control who can communicate with the cluster.
     */
    @JvmName("hbjmfrhapwwbiysw")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value A block that contains information about storage volumes attached to MSK broker nodes. See below.
     */
    @JvmName("tccxuoeiyawfnvrf")
    public suspend fun storageInfo(`value`: Output<ClusterBrokerNodeGroupInfoStorageInfoArgs>) {
        this.storageInfo = value
    }

    /**
     * @param value The distribution of broker nodes across availability zones ([documentation](https://docs.aws.amazon.com/msk/1.0/apireference/clusters.html#clusters-model-brokerazdistribution)). Currently the only valid value is `DEFAULT`.
     */
    @JvmName("jgofquxqocxfbxsd")
    public suspend fun azDistribution(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azDistribution = mapped
    }

    /**
     * @param value A list of subnets to connect to in client VPC ([documentation](https://docs.aws.amazon.com/msk/1.0/apireference/clusters.html#clusters-prop-brokernodegroupinfo-clientsubnets)).
     */
    @JvmName("ggrrpfuivqsyiebj")
    public suspend fun clientSubnets(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSubnets = mapped
    }

    /**
     * @param values A list of subnets to connect to in client VPC ([documentation](https://docs.aws.amazon.com/msk/1.0/apireference/clusters.html#clusters-prop-brokernodegroupinfo-clientsubnets)).
     */
    @JvmName("kmqppkbtoreybwoi")
    public suspend fun clientSubnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSubnets = mapped
    }

    /**
     * @param value Information about the cluster access configuration. See below. For security reasons, you can't turn on public access while creating an MSK cluster. However, you can update an existing cluster to make it publicly accessible. You can also create a new cluster and then update it to make it publicly accessible ([documentation](https://docs.aws.amazon.com/msk/latest/developerguide/public-access.html)).
     */
    @JvmName("ewdrkdtpnbifswnf")
    public suspend fun connectivityInfo(`value`: ClusterBrokerNodeGroupInfoConnectivityInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectivityInfo = mapped
    }

    /**
     * @param argument Information about the cluster access configuration. See below. For security reasons, you can't turn on public access while creating an MSK cluster. However, you can update an existing cluster to make it publicly accessible. You can also create a new cluster and then update it to make it publicly accessible ([documentation](https://docs.aws.amazon.com/msk/latest/developerguide/public-access.html)).
     */
    @JvmName("loynyoagetqmgpjb")
    public suspend fun connectivityInfo(argument: suspend ClusterBrokerNodeGroupInfoConnectivityInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterBrokerNodeGroupInfoConnectivityInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.connectivityInfo = mapped
    }

    /**
     * @param value Specify the instance type to use for the kafka brokersE.g., kafka.m5.large. ([Pricing info](https://aws.amazon.com/msk/pricing/))
     */
    @JvmName("sepwfvdovgbsfobx")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value A list of the security groups to associate with the elastic network interfaces to control who can communicate with the cluster.
     */
    @JvmName("wriiymtrrsmplerj")
    public suspend fun securityGroups(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values A list of the security groups to associate with the elastic network interfaces to control who can communicate with the cluster.
     */
    @JvmName("rwpcrxyxndbtwtdd")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value A block that contains information about storage volumes attached to MSK broker nodes. See below.
     */
    @JvmName("enyxxjvbcvybdbko")
    public suspend fun storageInfo(`value`: ClusterBrokerNodeGroupInfoStorageInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageInfo = mapped
    }

    /**
     * @param argument A block that contains information about storage volumes attached to MSK broker nodes. See below.
     */
    @JvmName("nwatamuxdpsmqdqp")
    public suspend fun storageInfo(argument: suspend ClusterBrokerNodeGroupInfoStorageInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterBrokerNodeGroupInfoStorageInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.storageInfo = mapped
    }

    internal fun build(): ClusterBrokerNodeGroupInfoArgs = ClusterBrokerNodeGroupInfoArgs(
        azDistribution = azDistribution,
        clientSubnets = clientSubnets ?: throw PulumiNullFieldException("clientSubnets"),
        connectivityInfo = connectivityInfo,
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        securityGroups = securityGroups ?: throw PulumiNullFieldException("securityGroups"),
        storageInfo = storageInfo,
    )
}
