@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property publicAccess Access control settings for brokers. See below.
 * @property vpcConnectivity VPC connectivity access control for brokers. See below.
 */
public data class ClusterBrokerNodeGroupInfoConnectivityInfoArgs(
    public val publicAccess: Output<ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessArgs>? =
        null,
    public val vpcConnectivity: Output<ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoArgs =
        com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoArgs.builder()
            .publicAccess(publicAccess?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vpcConnectivity(
                vpcConnectivity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterBrokerNodeGroupInfoConnectivityInfoArgs].
 */
@PulumiTagMarker
public class ClusterBrokerNodeGroupInfoConnectivityInfoArgsBuilder internal constructor() {
    private var publicAccess: Output<ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessArgs>? =
        null

    private var vpcConnectivity:
        Output<ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityArgs>? = null

    /**
     * @param value Access control settings for brokers. See below.
     */
    @JvmName("aynwwfevfdlfdqoh")
    public suspend fun publicAccess(`value`: Output<ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessArgs>) {
        this.publicAccess = value
    }

    /**
     * @param value VPC connectivity access control for brokers. See below.
     */
    @JvmName("vydysjxxvfqoxkwc")
    public suspend fun vpcConnectivity(`value`: Output<ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityArgs>) {
        this.vpcConnectivity = value
    }

    /**
     * @param value Access control settings for brokers. See below.
     */
    @JvmName("fvynigvsiclxakww")
    public suspend fun publicAccess(`value`: ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicAccess = mapped
    }

    /**
     * @param argument Access control settings for brokers. See below.
     */
    @JvmName("yelrkrlhtwdognoq")
    public suspend fun publicAccess(argument: suspend ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessArgsBuilder.() -> Unit) {
        val toBeMapped =
            ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.publicAccess = mapped
    }

    /**
     * @param value VPC connectivity access control for brokers. See below.
     */
    @JvmName("bnifynkllkdeghpv")
    public suspend fun vpcConnectivity(`value`: ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConnectivity = mapped
    }

    /**
     * @param argument VPC connectivity access control for brokers. See below.
     */
    @JvmName("vrjarbexxmbysnhl")
    public suspend fun vpcConnectivity(argument: suspend ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityArgsBuilder.() -> Unit) {
        val toBeMapped =
            ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.vpcConnectivity = mapped
    }

    internal fun build(): ClusterBrokerNodeGroupInfoConnectivityInfoArgs =
        ClusterBrokerNodeGroupInfoConnectivityInfoArgs(
            publicAccess = publicAccess,
            vpcConnectivity = vpcConnectivity,
        )
}
