@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property clientAuthentication Configuration block for specifying a client authentication. See below.
 */
public data class ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityArgs(
    public val clientAuthentication: Output<ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityArgs =
        com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityArgs.builder()
            .clientAuthentication(
                clientAuthentication?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityArgs].
 */
@PulumiTagMarker
public class ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityArgsBuilder internal constructor() {
    private var clientAuthentication:
        Output<ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationArgs>? =
        null

    /**
     * @param value Configuration block for specifying a client authentication. See below.
     */
    @JvmName("wkhohlnuogcbtvml")
    public suspend fun clientAuthentication(`value`: Output<ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationArgs>) {
        this.clientAuthentication = value
    }

    /**
     * @param value Configuration block for specifying a client authentication. See below.
     */
    @JvmName("xnnfeysudxjpwvac")
    public suspend fun clientAuthentication(`value`: ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAuthentication = mapped
    }

    /**
     * @param argument Configuration block for specifying a client authentication. See below.
     */
    @JvmName("xobjotvrkyijsxci")
    public suspend fun clientAuthentication(argument: suspend ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.clientAuthentication = mapped
    }

    internal fun build(): ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityArgs =
        ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityArgs(
            clientAuthentication = clientAuthentication,
        )
}
