@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property sasl Configuration block for specifying SASL client authentication. See below.
 * @property tls Configuration block for specifying TLS client authentication. See below.
 */
public data class ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationArgs(
    public val sasl: Output<ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslArgs>? =
        null,
    public val tls: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationArgs =
        com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationArgs.builder()
            .sasl(sasl?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tls(tls?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationArgs].
 */
@PulumiTagMarker
public class
ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationArgsBuilder
internal constructor() {
    private var sasl:
        Output<ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslArgs>? =
        null

    private var tls: Output<Boolean>? = null

    /**
     * @param value Configuration block for specifying SASL client authentication. See below.
     */
    @JvmName("gswexmmvoaqtdjxb")
    public suspend fun sasl(`value`: Output<ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslArgs>) {
        this.sasl = value
    }

    /**
     * @param value Configuration block for specifying TLS client authentication. See below.
     */
    @JvmName("totgoxtysdwbelvs")
    public suspend fun tls(`value`: Output<Boolean>) {
        this.tls = value
    }

    /**
     * @param value Configuration block for specifying SASL client authentication. See below.
     */
    @JvmName("agwvedmhteqxltwm")
    public suspend fun sasl(`value`: ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasl = mapped
    }

    /**
     * @param argument Configuration block for specifying SASL client authentication. See below.
     */
    @JvmName("dsqynyhgrmstdsuy")
    public suspend fun sasl(argument: suspend ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslArgsBuilder.() -> Unit) {
        val toBeMapped =
            ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sasl = mapped
    }

    /**
     * @param value Configuration block for specifying TLS client authentication. See below.
     */
    @JvmName("kigdkpvchppuiwdd")
    public suspend fun tls(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tls = mapped
    }

    internal fun build(): ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationArgs =
        ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationArgs(
            sasl = sasl,
            tls = tls,
        )
}
