@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property ebsStorageInfo A block that contains EBS volume information. See below.
 */
public data class ClusterBrokerNodeGroupInfoStorageInfoArgs(
    public val ebsStorageInfo: Output<ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoArgs =
        com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoArgs.builder()
            .ebsStorageInfo(
                ebsStorageInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterBrokerNodeGroupInfoStorageInfoArgs].
 */
@PulumiTagMarker
public class ClusterBrokerNodeGroupInfoStorageInfoArgsBuilder internal constructor() {
    private var ebsStorageInfo: Output<ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs>? =
        null

    /**
     * @param value A block that contains EBS volume information. See below.
     */
    @JvmName("slrfwlbaakoochgn")
    public suspend fun ebsStorageInfo(`value`: Output<ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs>) {
        this.ebsStorageInfo = value
    }

    /**
     * @param value A block that contains EBS volume information. See below.
     */
    @JvmName("qmcuqthyhnwtiath")
    public suspend fun ebsStorageInfo(`value`: ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsStorageInfo = mapped
    }

    /**
     * @param argument A block that contains EBS volume information. See below.
     */
    @JvmName("mwtpqeebcmjkkafp")
    public suspend fun ebsStorageInfo(argument: suspend ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ebsStorageInfo = mapped
    }

    internal fun build(): ClusterBrokerNodeGroupInfoStorageInfoArgs =
        ClusterBrokerNodeGroupInfoStorageInfoArgs(
            ebsStorageInfo = ebsStorageInfo,
        )
}
