@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property provisionedThroughput A block that contains EBS volume provisioned throughput information. To provision storage throughput, you must choose broker type kafka.m5.4xlarge or larger. See below.
 * @property volumeSize The size in GiB of the EBS volume for the data drive on each broker node. Minimum value of `1` and maximum value of `16384`.
 */
public data class ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs(
    public val provisionedThroughput: Output<ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgs>? = null,
    public val volumeSize: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs =
        com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs.builder()
            .provisionedThroughput(
                provisionedThroughput?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .volumeSize(volumeSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs].
 */
@PulumiTagMarker
public class ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgsBuilder internal constructor() {
    private var provisionedThroughput:
        Output<ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgs>? = null

    private var volumeSize: Output<Int>? = null

    /**
     * @param value A block that contains EBS volume provisioned throughput information. To provision storage throughput, you must choose broker type kafka.m5.4xlarge or larger. See below.
     */
    @JvmName("lussbediyiirqrpn")
    public suspend fun provisionedThroughput(`value`: Output<ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgs>) {
        this.provisionedThroughput = value
    }

    /**
     * @param value The size in GiB of the EBS volume for the data drive on each broker node. Minimum value of `1` and maximum value of `16384`.
     */
    @JvmName("ajaanblhsiwlyltl")
    public suspend fun volumeSize(`value`: Output<Int>) {
        this.volumeSize = value
    }

    /**
     * @param value A block that contains EBS volume provisioned throughput information. To provision storage throughput, you must choose broker type kafka.m5.4xlarge or larger. See below.
     */
    @JvmName("gnlgamnrcbdwbfnm")
    public suspend fun provisionedThroughput(`value`: ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionedThroughput = mapped
    }

    /**
     * @param argument A block that contains EBS volume provisioned throughput information. To provision storage throughput, you must choose broker type kafka.m5.4xlarge or larger. See below.
     */
    @JvmName("imgghcbcfxjrjjbi")
    public suspend fun provisionedThroughput(argument: suspend ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgsBuilder.() -> Unit) {
        val toBeMapped =
            ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.provisionedThroughput = mapped
    }

    /**
     * @param value The size in GiB of the EBS volume for the data drive on each broker node. Minimum value of `1` and maximum value of `16384`.
     */
    @JvmName("ktnnsoacnepwnskq")
    public suspend fun volumeSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeSize = mapped
    }

    internal fun build(): ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs =
        ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs(
            provisionedThroughput = provisionedThroughput,
            volumeSize = volumeSize,
        )
}
