@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled
 * @property volumeThroughput Throughput value of the EBS volumes for the data drive on each kafka broker node in MiB per second. The minimum value is `250`. The maximum value varies between broker type. You can refer to the valid values for the maximum volume throughput at the following [documentation on throughput bottlenecks](https://docs.aws.amazon.com/msk/latest/developerguide/msk-provision-throughput.html#throughput-bottlenecks)
 */
public data class ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgs(
    public val enabled: Output<Boolean>? = null,
    public val volumeThroughput: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgs =
        com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .volumeThroughput(volumeThroughput?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgs].
 */
@PulumiTagMarker
public class ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgsBuilder
internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var volumeThroughput: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("pdaejpgcvoaevlkq")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Throughput value of the EBS volumes for the data drive on each kafka broker node in MiB per second. The minimum value is `250`. The maximum value varies between broker type. You can refer to the valid values for the maximum volume throughput at the following [documentation on throughput bottlenecks](https://docs.aws.amazon.com/msk/latest/developerguide/msk-provision-throughput.html#throughput-bottlenecks)
     */
    @JvmName("nffflbmeeytmuryg")
    public suspend fun volumeThroughput(`value`: Output<Int>) {
        this.volumeThroughput = value
    }

    /**
     * @param value
     */
    @JvmName("ohojqlfxvruvooes")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Throughput value of the EBS volumes for the data drive on each kafka broker node in MiB per second. The minimum value is `250`. The maximum value varies between broker type. You can refer to the valid values for the maximum volume throughput at the following [documentation on throughput bottlenecks](https://docs.aws.amazon.com/msk/latest/developerguide/msk-provision-throughput.html#throughput-bottlenecks)
     */
    @JvmName("gssneqdxnulxyhka")
    public suspend fun volumeThroughput(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeThroughput = mapped
    }

    internal fun build(): ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgs = ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgs(
        enabled = enabled,
        volumeThroughput = volumeThroughput,
    )
}
