@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterClientAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property sasl Configuration block for specifying SASL client authentication. See below.
 * @property tls Configuration block for specifying TLS client authentication. See below.
 * @property unauthenticated Enables unauthenticated access.
 */
public data class ClusterClientAuthenticationArgs(
    public val sasl: Output<ClusterClientAuthenticationSaslArgs>? = null,
    public val tls: Output<ClusterClientAuthenticationTlsArgs>? = null,
    public val unauthenticated: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterClientAuthenticationArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterClientAuthenticationArgs =
        com.pulumi.aws.msk.inputs.ClusterClientAuthenticationArgs.builder()
            .sasl(sasl?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tls(tls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .unauthenticated(unauthenticated?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterClientAuthenticationArgs].
 */
@PulumiTagMarker
public class ClusterClientAuthenticationArgsBuilder internal constructor() {
    private var sasl: Output<ClusterClientAuthenticationSaslArgs>? = null

    private var tls: Output<ClusterClientAuthenticationTlsArgs>? = null

    private var unauthenticated: Output<Boolean>? = null

    /**
     * @param value Configuration block for specifying SASL client authentication. See below.
     */
    @JvmName("gaopvukjsxtjuihc")
    public suspend fun sasl(`value`: Output<ClusterClientAuthenticationSaslArgs>) {
        this.sasl = value
    }

    /**
     * @param value Configuration block for specifying TLS client authentication. See below.
     */
    @JvmName("trxsleieglhixyyr")
    public suspend fun tls(`value`: Output<ClusterClientAuthenticationTlsArgs>) {
        this.tls = value
    }

    /**
     * @param value Enables unauthenticated access.
     */
    @JvmName("erahbcxxvodruuqj")
    public suspend fun unauthenticated(`value`: Output<Boolean>) {
        this.unauthenticated = value
    }

    /**
     * @param value Configuration block for specifying SASL client authentication. See below.
     */
    @JvmName("hddohlqdqpxsxgwt")
    public suspend fun sasl(`value`: ClusterClientAuthenticationSaslArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasl = mapped
    }

    /**
     * @param argument Configuration block for specifying SASL client authentication. See below.
     */
    @JvmName("rqpryoqurweblsfg")
    public suspend fun sasl(argument: suspend ClusterClientAuthenticationSaslArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterClientAuthenticationSaslArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sasl = mapped
    }

    /**
     * @param value Configuration block for specifying TLS client authentication. See below.
     */
    @JvmName("rlyadfkvuesqqjcj")
    public suspend fun tls(`value`: ClusterClientAuthenticationTlsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tls = mapped
    }

    /**
     * @param argument Configuration block for specifying TLS client authentication. See below.
     */
    @JvmName("psbynmiocpgcpmww")
    public suspend fun tls(argument: suspend ClusterClientAuthenticationTlsArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterClientAuthenticationTlsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tls = mapped
    }

    /**
     * @param value Enables unauthenticated access.
     */
    @JvmName("kchfobfsmnpttbso")
    public suspend fun unauthenticated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unauthenticated = mapped
    }

    internal fun build(): ClusterClientAuthenticationArgs = ClusterClientAuthenticationArgs(
        sasl = sasl,
        tls = tls,
        unauthenticated = unauthenticated,
    )
}
