@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterEncryptionInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property encryptionAtRestKmsKeyArn You may specify a KMS key short ID or ARN (it will always output an ARN) to use for encrypting your data at rest.  If no key is specified, an AWS managed KMS ('aws/msk' managed service) key will be used for encrypting the data at rest.
 * @property encryptionInTransit Configuration block to specify encryption in transit. See below.
 */
public data class ClusterEncryptionInfoArgs(
    public val encryptionAtRestKmsKeyArn: Output<String>? = null,
    public val encryptionInTransit: Output<ClusterEncryptionInfoEncryptionInTransitArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterEncryptionInfoArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterEncryptionInfoArgs =
        com.pulumi.aws.msk.inputs.ClusterEncryptionInfoArgs.builder()
            .encryptionAtRestKmsKeyArn(encryptionAtRestKmsKeyArn?.applyValue({ args0 -> args0 }))
            .encryptionInTransit(
                encryptionInTransit?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterEncryptionInfoArgs].
 */
@PulumiTagMarker
public class ClusterEncryptionInfoArgsBuilder internal constructor() {
    private var encryptionAtRestKmsKeyArn: Output<String>? = null

    private var encryptionInTransit: Output<ClusterEncryptionInfoEncryptionInTransitArgs>? = null

    /**
     * @param value You may specify a KMS key short ID or ARN (it will always output an ARN) to use for encrypting your data at rest.  If no key is specified, an AWS managed KMS ('aws/msk' managed service) key will be used for encrypting the data at rest.
     */
    @JvmName("qowusbabewjqrebe")
    public suspend fun encryptionAtRestKmsKeyArn(`value`: Output<String>) {
        this.encryptionAtRestKmsKeyArn = value
    }

    /**
     * @param value Configuration block to specify encryption in transit. See below.
     */
    @JvmName("yjxhellhayjyqaev")
    public suspend fun encryptionInTransit(`value`: Output<ClusterEncryptionInfoEncryptionInTransitArgs>) {
        this.encryptionInTransit = value
    }

    /**
     * @param value You may specify a KMS key short ID or ARN (it will always output an ARN) to use for encrypting your data at rest.  If no key is specified, an AWS managed KMS ('aws/msk' managed service) key will be used for encrypting the data at rest.
     */
    @JvmName("eafytmqfkdvbrcts")
    public suspend fun encryptionAtRestKmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionAtRestKmsKeyArn = mapped
    }

    /**
     * @param value Configuration block to specify encryption in transit. See below.
     */
    @JvmName("avnypvmogkoofkfc")
    public suspend fun encryptionInTransit(`value`: ClusterEncryptionInfoEncryptionInTransitArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionInTransit = mapped
    }

    /**
     * @param argument Configuration block to specify encryption in transit. See below.
     */
    @JvmName("jbljetwhmbxmfhvl")
    public suspend fun encryptionInTransit(argument: suspend ClusterEncryptionInfoEncryptionInTransitArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterEncryptionInfoEncryptionInTransitArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.encryptionInTransit = mapped
    }

    internal fun build(): ClusterEncryptionInfoArgs = ClusterEncryptionInfoArgs(
        encryptionAtRestKmsKeyArn = encryptionAtRestKmsKeyArn,
        encryptionInTransit = encryptionInTransit,
    )
}
