@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterLoggingInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property brokerLogs Configuration block for Broker Logs settings for logging info. See below.
 */
public data class ClusterLoggingInfoArgs(
    public val brokerLogs: Output<ClusterLoggingInfoBrokerLogsArgs>,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterLoggingInfoArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterLoggingInfoArgs =
        com.pulumi.aws.msk.inputs.ClusterLoggingInfoArgs.builder()
            .brokerLogs(brokerLogs.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ClusterLoggingInfoArgs].
 */
@PulumiTagMarker
public class ClusterLoggingInfoArgsBuilder internal constructor() {
    private var brokerLogs: Output<ClusterLoggingInfoBrokerLogsArgs>? = null

    /**
     * @param value Configuration block for Broker Logs settings for logging info. See below.
     */
    @JvmName("hvdrjjuaocsdnred")
    public suspend fun brokerLogs(`value`: Output<ClusterLoggingInfoBrokerLogsArgs>) {
        this.brokerLogs = value
    }

    /**
     * @param value Configuration block for Broker Logs settings for logging info. See below.
     */
    @JvmName("wvkpxnmbmagagepi")
    public suspend fun brokerLogs(`value`: ClusterLoggingInfoBrokerLogsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.brokerLogs = mapped
    }

    /**
     * @param argument Configuration block for Broker Logs settings for logging info. See below.
     */
    @JvmName("rosiqsfrsmhcigen")
    public suspend fun brokerLogs(argument: suspend ClusterLoggingInfoBrokerLogsArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterLoggingInfoBrokerLogsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.brokerLogs = mapped
    }

    internal fun build(): ClusterLoggingInfoArgs = ClusterLoggingInfoArgs(
        brokerLogs = brokerLogs ?: throw PulumiNullFieldException("brokerLogs"),
    )
}
