@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsFirehoseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deliveryStream Name of the Kinesis Data Firehose delivery stream to deliver logs to.
 * @property enabled
 */
public data class ClusterLoggingInfoBrokerLogsFirehoseArgs(
    public val deliveryStream: Output<String>? = null,
    public val enabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsFirehoseArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsFirehoseArgs =
        com.pulumi.aws.msk.inputs.ClusterLoggingInfoBrokerLogsFirehoseArgs.builder()
            .deliveryStream(deliveryStream?.applyValue({ args0 -> args0 }))
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterLoggingInfoBrokerLogsFirehoseArgs].
 */
@PulumiTagMarker
public class ClusterLoggingInfoBrokerLogsFirehoseArgsBuilder internal constructor() {
    private var deliveryStream: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value Name of the Kinesis Data Firehose delivery stream to deliver logs to.
     */
    @JvmName("xytfmryepoxxvdfy")
    public suspend fun deliveryStream(`value`: Output<String>) {
        this.deliveryStream = value
    }

    /**
     * @param value
     */
    @JvmName("uyrupwoobfkonfxa")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Name of the Kinesis Data Firehose delivery stream to deliver logs to.
     */
    @JvmName("xtlpleswbxubmfpu")
    public suspend fun deliveryStream(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryStream = mapped
    }

    /**
     * @param value
     */
    @JvmName("lstvbgtbwnthjtdl")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ClusterLoggingInfoBrokerLogsFirehoseArgs =
        ClusterLoggingInfoBrokerLogsFirehoseArgs(
            deliveryStream = deliveryStream,
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        )
}
