@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.GetBootstrapBrokersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBootstrapBrokers.
 * @property clusterArn ARN of the cluster the nodes belong to.
 */
public data class GetBootstrapBrokersPlainArgs(
    public val clusterArn: String,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.GetBootstrapBrokersPlainArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.GetBootstrapBrokersPlainArgs =
        com.pulumi.aws.msk.inputs.GetBootstrapBrokersPlainArgs.builder()
            .clusterArn(clusterArn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBootstrapBrokersPlainArgs].
 */
@PulumiTagMarker
public class GetBootstrapBrokersPlainArgsBuilder internal constructor() {
    private var clusterArn: String? = null

    /**
     * @param value ARN of the cluster the nodes belong to.
     */
    @JvmName("plrvinjovqvpgvai")
    public suspend fun clusterArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterArn = mapped
    }

    internal fun build(): GetBootstrapBrokersPlainArgs = GetBootstrapBrokersPlainArgs(
        clusterArn = clusterArn ?: throw PulumiNullFieldException("clusterArn"),
    )
}
