@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.GetClusterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCluster.
 * @property clusterName Name of the cluster.
 * @property tags Map of key-value pairs assigned to the cluster.
 */
public data class GetClusterPlainArgs(
    public val clusterName: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.GetClusterPlainArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.GetClusterPlainArgs =
        com.pulumi.aws.msk.inputs.GetClusterPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetClusterPlainArgs].
 */
@PulumiTagMarker
public class GetClusterPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the cluster.
     */
    @JvmName("igdddrpskokrrdwr")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value Map of key-value pairs assigned to the cluster.
     */
    @JvmName("forbbiaaltxlkfdk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of key-value pairs assigned to the cluster.
     */
    @JvmName("ntatjnrhkqakdabm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetClusterPlainArgs = GetClusterPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        tags = tags,
    )
}
