@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.GetKafkaVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getKafkaVersion.
 * @property preferredVersions Ordered list of preferred Kafka versions. The first match in this list will be returned. Either `preferred_versions` or `version` must be set.
 * @property version Version of MSK Kafka. For example 2.4.1.1 or "2.2.1" etc. Either `preferred_versions` or `version` must be set.
 */
public data class GetKafkaVersionPlainArgs(
    public val preferredVersions: List<String>? = null,
    public val version: String? = null,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.GetKafkaVersionPlainArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.GetKafkaVersionPlainArgs =
        com.pulumi.aws.msk.inputs.GetKafkaVersionPlainArgs.builder()
            .preferredVersions(preferredVersions?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .version(version?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKafkaVersionPlainArgs].
 */
@PulumiTagMarker
public class GetKafkaVersionPlainArgsBuilder internal constructor() {
    private var preferredVersions: List<String>? = null

    private var version: String? = null

    /**
     * @param value Ordered list of preferred Kafka versions. The first match in this list will be returned. Either `preferred_versions` or `version` must be set.
     */
    @JvmName("coskikpyigdvfbby")
    public suspend fun preferredVersions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.preferredVersions = mapped
    }

    /**
     * @param values Ordered list of preferred Kafka versions. The first match in this list will be returned. Either `preferred_versions` or `version` must be set.
     */
    @JvmName("temikhjyyioulkkj")
    public suspend fun preferredVersions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.preferredVersions = mapped
    }

    /**
     * @param value Version of MSK Kafka. For example 2.4.1.1 or "2.2.1" etc. Either `preferred_versions` or `version` must be set.
     */
    @JvmName("ewhypstjnnicytdo")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetKafkaVersionPlainArgs = GetKafkaVersionPlainArgs(
        preferredVersions = preferredVersions,
        version = version,
    )
}
